import { Module, forwardRef } from '@nestjs/common';
import { UserService } from './user.service';
import { UserController } from './user.controller';
import { UserRepository } from './user.repository';
import { TypeOrmModule } from '@nestjs/typeorm';
import { User, UserRoleMap } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { RegistrationModule } from 'src/registration/registration.module';
import { UserProfileExtensionModule } from 'src/user-profile-extension/user-profile-extension.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([User, UserRoleMap]),
    forwardRef(() => AuthModule),
    forwardRef(() => RegistrationModule),
    forwardRef(() => UserProfileExtensionModule),
  ],
  controllers: [UserController],
  providers: [UserService, UserRepository],
  exports: [UserService, UserRepository],
})
export class UserModule {}
