import { ApiProperty } from '@nestjs/swagger';
import { IsOptional, IsString, IsBoolean, IsDateString } from 'class-validator';

export class CreateUserDto {
  @ApiProperty({ example: '1234567890' })
  @IsString()
  phoneNumber: string;    

  @ApiProperty({ example: '+91' })
  @IsString()
  countryCode: string;

  @ApiProperty({ example: 'john.doe@gmail.com' })
  @IsString()
  email: string;
  
  @ApiProperty({ example: 'John', required: false })
  @IsOptional()
  @IsString()
  firstName?: string;

  @ApiProperty({ example: 'Doe', required: false })
  @IsOptional()
  @IsString()
  lastName?: string;

  @ApiProperty({ example: 'John Doe', required: false })
  @IsOptional()
  @IsString()
  fullName?: string;

  @ApiProperty({ example: 'John Doe', required: false })
  @IsOptional()
  @IsString()
  legalFullName?: string;

  @ApiProperty({ example: 'Address', required: false })
  @IsOptional()
  @IsString()
  address?: string;

  @ApiProperty({ example: 'India', required: false })
  @IsOptional()
  @IsString()
  countryName?: string;

  @ApiProperty({ example: 'Other address', required: false })
  @IsOptional()
  @IsString()
  otherAddress?: string;

  @ApiProperty({ example: '1990-01-01', required: false })
  @IsOptional()
  @IsDateString()
  dob?: string;

  @ApiProperty({ example: true })
  @IsOptional()
  @IsBoolean()
  termsAndConditions?: boolean;

  @ApiProperty({ example: 'Male', required: false })
  @IsOptional()
  @IsString()
  gender?: string;

  @ApiProperty({ example: 'viewer' })
  @IsString()
  role: string;
}
