import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { ArrayNotEmpty, ArrayUnique, IsArray, IsInt, IsPositive } from 'class-validator';

export class UpdateUserRegistrationMapDto {
  @ApiProperty({ description: 'Seeker identifier', example: 101 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  userId: number;

  @ApiProperty({
    description: 'Completed registration identifiers that should remain mapped to the user',
    type: [Number],
    example: [201, 202],
  })
  @IsArray()
  @ArrayNotEmpty()
  @ArrayUnique()
  @Type(() => Number)
  @IsInt({ each: true })
  @IsPositive({ each: true })
  registrationIds: number[];

  @ApiProperty({ description: 'User performing the update', example: 2 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  updatedBy: number;
}
