import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  ArrayNotEmpty,
  ArrayUnique,
  IsArray,
  IsInt,
  IsOptional,
  IsPositive,
} from 'class-validator';

export class DeleteUserRegistrationMapDto {
  @ApiProperty({ description: 'Seeker identifier', example: 101 })
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  userId: number;

  @ApiProperty({
    description: 'Registration identifiers to unlink from the user',
    type: [Number],
    example: [201],
  })
  @IsArray()
  @ArrayNotEmpty()
  @ArrayUnique()
  @Type(() => Number)
  @IsInt({ each: true })
  @IsPositive({ each: true })
  registrationIds: number[];

  @ApiProperty({ description: 'User performing the deletion', example: 3, required: false })
  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @IsPositive()
  updatedBy?: number;
}
