import { ApiProperty } from '@nestjs/swagger';
import { ArrayNotEmpty, IsArray, IsDateString, IsInt, IsOptional } from 'class-validator';
import { Type } from 'class-transformer';

export class CreateUserProgramExperienceDto {
  @ApiProperty({ description: 'Identifier of the seeker user', example: 101 })
  @IsInt()
  @Type(() => Number)
  userId: number;

  @ApiProperty({
    description: 'Associated registration identifier when applicable',
    example: 2024,
    required: false,
    nullable: true,
  })
  @IsOptional()
  @IsInt()
  @Type(() => Number)
  registrationId?: number | null;

  @ApiProperty({
    description: 'Lookup data identifiers representing seeker program experiences',
    type: [Number],
    example: [11, 12, 13],
  })
  @IsArray()
  @ArrayNotEmpty()
  @IsInt({ each: true })
  @Type(() => Number)
  lookupDataIds: number[];

  @ApiProperty({ description: 'User identifier capturing the record', example: 301 })
  @IsInt()
  @Type(() => Number)
  createdBy: number;

  @ApiProperty({ description: 'User identifier performing the latest update', example: 301 })
  @IsInt()
  @Type(() => Number)
  updatedBy: number;

  @ApiProperty({ description: 'Explicit creation timestamp', required: false })
  @IsOptional()
  @IsDateString()
  createdAt?: string;

  @ApiProperty({ description: 'Explicit update timestamp', required: false })
  @IsOptional()
  @IsDateString()
  updatedAt?: string;

  @ApiProperty({ description: 'Explicit deletion timestamp', required: false, nullable: true })
  @IsOptional()
  @IsDateString()
  deletedAt?: string;
}
