import { Injectable, NotFoundException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository, EntityManager } from 'typeorm';
import { CreateUserProfileExtensionDto } from './dto/create-user-profile-extension.dto';
import { UpdateUserProfileExtensionDto } from './dto/update-user-profile-extension.dto';
import { UserProfileExtensionRepository } from './user-profile-extension.repository';
import { UserProfileExtension } from 'src/common/entities/user-profile-extension.entity';
import { CommonDataService } from 'src/common/services/commonData.service';
import { User } from 'src/common/entities/user.entity';

@Injectable()
export class UserProfileExtensionService {
  constructor(
    private readonly userProfileExtensionRepository: UserProfileExtensionRepository,
    private readonly commonDataService: CommonDataService,
    @InjectRepository(User)
    private readonly userRepo: Repository<User>,
  ) {}

  async create(
    createUserProfileExtensionDto: CreateUserProfileExtensionDto,
    manager?: EntityManager,
  ): Promise<UserProfileExtension> {
    return this.userProfileExtensionRepository.create(createUserProfileExtensionDto, manager);
  }

  async createEmpty(userId: number, manager?: EntityManager): Promise<UserProfileExtension> {
    return this.userProfileExtensionRepository.createEmpty(userId, manager);
  }

  async findByUserId(userId: number): Promise<UserProfileExtension | null> {
    const profileExtension = await this.userProfileExtensionRepository.findByUserId(userId);
    return profileExtension || null;
  }

  async updateByUserId(
    userId: number,
    updateUserProfileExtensionDto: UpdateUserProfileExtensionDto,
    manager?: EntityManager,
  ): Promise<UserProfileExtension> {
    // Handle infinitheism contact name lookup if ID is provided
    if (updateUserProfileExtensionDto.infinitheismContactId) {
      try {
        const contactUser = await this.commonDataService.findOneById(
          this.userRepo,
          updateUserProfileExtensionDto.infinitheismContactId,
        );
        if (contactUser) {
          if (contactUser.firstName !== 'Other') {
            updateUserProfileExtensionDto.contactPerson = contactUser.firstName;
          }
        }
      } catch (error) {
        // If user lookup fails, we'll still proceed with the update
        console.warn(`Failed to lookup infinitheism contact name for ID ${updateUserProfileExtensionDto.infinitheismContactId}`);
      }
    }

    return this.userProfileExtensionRepository.updateByUserId(
      userId,
      updateUserProfileExtensionDto,
      manager,
    );
  }

  async remove(id: number, manager?: EntityManager): Promise<void> {
    return this.userProfileExtensionRepository.remove(id, manager);
  }
}