import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { UserParticipationController } from './user-participation.controller';
import { UserParticipationService } from './user-participation.service';
import { UserParticipationRepository } from './user-participation.repository';
import { UserParticipationSummary } from '../common/entities/user-participation-summary.entity';
import { User } from '../common/entities/user.entity';
import { UserProfileExtension } from '../common/entities/user-profile-extension.entity';
import { Program } from '../common/entities/program.entity';
import { ProgramType } from '../common/entities/program-type.entity';
import { AuthModule } from '../auth/auth.module';
import { UserModule } from '../user/user.module';
import { CommonDataService } from '../common/services/commonData.service';
import { AppLoggerService } from '../common/services/logger.service';
import { UserProgramExperienceModule } from '../user-program-experience/user-program-experience.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([UserParticipationSummary, User, UserProfileExtension, Program, ProgramType]),
    AuthModule,
    UserModule,
    UserProgramExperienceModule,
  ],
  controllers: [UserParticipationController],
  providers: [
    UserParticipationService,
    UserParticipationRepository,
    CommonDataService,
    AppLoggerService,
  ],
  exports: [
    UserParticipationService,
    UserParticipationRepository,
  ],
})
export class UserParticipationModule {}
