import { ApiProperty } from '@nestjs/swagger';
import { IsOptional, IsInt, Min } from 'class-validator';
import { Type } from 'class-transformer';

export class GetUserParticipationQueryDto {
  @ApiProperty({ description: 'Specific year filter', required: false })
  @IsOptional()
  @IsInt()
  @Min(2000)
  @Type(() => Number)
  year?: number;

  @ApiProperty({ description: 'Program name filter', required: false })
  @IsOptional()
  programName?: string;

  @ApiProperty({ description: 'Include detailed program information', default: true, required: false })
  @IsOptional()
  includeDetails?: boolean = true;
}
