import { ApiPropertyOptional } from '@nestjs/swagger';
import { IsBoolean, IsOptional, IsString, MaxLength } from 'class-validator';

export class UpdateSeekerProgramExperienceDto {
  @ApiPropertyOptional({ description: 'Type of experience shared (e.g., video, audio, note)' })
  @IsOptional()
  @IsString()
  @MaxLength(100)
  type?: string;

  @ApiPropertyOptional({ description: 'Experience message or caption' })
  @IsOptional()
  @IsString()
  message?: string;

  @ApiPropertyOptional({ description: 'S3 URL of the uploaded media' })
  @IsOptional()
  @IsString()
  mediaUrl?: string;

  @ApiPropertyOptional({ description: 'Whether the record is private' })
  @IsOptional()
  @IsBoolean()
  isPrivate?: boolean;

  @ApiPropertyOptional({ description: 'Whether the record has been marked as viewed' })
  @IsOptional()
  @IsBoolean()
  isViewed?: boolean;

  @ApiPropertyOptional({ description: 'Whether the record has been approved' })
  @IsOptional()
  @IsBoolean()
  isApproved?: boolean;
}