import { ApiPropertyOptional } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsBoolean, IsInt, IsOptional, IsString, Max, Min, IsEnum } from 'class-validator';
import { ApprovalStatusEnum } from 'src/common/enum/approval-status.enum';

export class FilterSeekerProgramExperienceDto {
  
  @ApiPropertyOptional({ description: 'Sort key (field to sort by)', example: 'createdAt' })
  @IsOptional()
  @IsString()
  sortKey?: string;

  @ApiPropertyOptional({ description: 'Sort direction (ASC or DESC)', example: 'DESC' })
  @IsOptional()
  @IsString()
  sortOrder?: 'ASC' | 'DESC';

  @ApiPropertyOptional({ description: 'Filter by programId from registration' })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  programId?: number;

  @ApiPropertyOptional({ description: 'Filter by allocatedProgramId from registration' })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  allocatedProgramId?: number;

  @ApiPropertyOptional({ description: 'Pagination limit', default: 10 })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  @Min(1)
  @Max(100)
  limit?: number = 10;

  @ApiPropertyOptional({ description: 'Pagination offset', default: 0 })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  @Min(0)
  offset?: number = 0;

  @ApiPropertyOptional({ description: 'Search by message or type' })
  @IsOptional()
  @IsString()
  search?: string;

  @ApiPropertyOptional({ description: 'Filter by experience type' })
  @IsOptional()
  @IsString()
  type?: string;

  @ApiPropertyOptional({ description: 'Filter by seeker user identifier' })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  userId?: number;

  @ApiPropertyOptional({ description: 'Filter by program registration identifier' })
  @Type(() => Number)
  @IsOptional()
  @IsInt()
  registrationId?: number;

  @ApiPropertyOptional({ description: 'Filter by privacy flag' })
  @Type(() => Boolean)
  @IsOptional()
  @IsBoolean()
  isPrivate?: boolean;

  @ApiPropertyOptional({ description: 'Filter by approval flag' })
  @Type(() => Boolean)
  @IsOptional()
  @IsBoolean()
  isApproved?: boolean;

  @ApiPropertyOptional({ description: 'Filter by viewed flag' })
  @Type(() => Boolean)
  @IsOptional()
  @IsBoolean()
  isViewed?: boolean;

  @ApiPropertyOptional({ description: 'Include soft deleted records' })
  @Type(() => Boolean)
  @IsOptional()
  @IsBoolean()
  includeDeleted?: boolean;

  @ApiPropertyOptional({ 
    description: 'Filter by registration approval status',
    enum: ApprovalStatusEnum,
    example: ApprovalStatusEnum.APPROVED
  })
  @IsOptional()
  @IsEnum(ApprovalStatusEnum)
  approvalStatus?: ApprovalStatusEnum;
}