import { forwardRef, Module } from '@nestjs/common';
import { SchedulerService } from './scheduler.service';
import { SchedulerController } from './scheduler.controller';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { ProgramRegistrationModule } from 'src/program-registration/program-registration.module';
import { ProgramModule } from 'src/program/program.module';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTemplates, Program, ProgramRegistration, User, SchedulerLog } from 'src/common/entities';
import { UserRepository } from 'src/user/user.repository';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { CommunicationModule } from 'src/communication/communication.module';
import { CommunicationTemplatesRepository } from 'src/communication/repositories/communication-templates.repository';
import { SchedulerLogRepository } from './scheduler-log.repository';
import { RegistrationModule } from 'src/registration/registration.module';
import { FeatureFlagModule } from 'src/feature-flag/feature-flag.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Program, ProgramRegistration, User, CommunicationTemplates, SchedulerLog]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => ProgramRegistrationModule),
    forwardRef(() => ProgramModule),
    forwardRef(() => CommunicationModule),
    forwardRef(() => RegistrationModule),
    forwardRef(() => FeatureFlagModule),
  ],
  controllers: [SchedulerController],
  providers: [
    SchedulerService,
    CommonDataService,
    AppLoggerService,
    UserRepository,
    ProgramRegistrationRepository,
    CommunicationTemplatesRepository,
    SchedulerLogRepository,
  ],
})
export class SchedulerModule {}
