import { ApiProperty } from '@nestjs/swagger';

/**
 * DTO for room status KPIs
 */
export class RoomStatusKpiDto {
  @ApiProperty({ description: 'Room status', example: 'AVAILABLE' })
  status: string[];

  @ApiProperty({ description: 'Display label for the status with proper capitalization', example: 'Available' })
  label: string;

  @ApiProperty({ description: 'Total count of rooms with this status', example: 15 })
  count: number;
}

/**
 * DTO for filter dropdown options
 */
export class FilterOptionDto {
  @ApiProperty({ description: 'Display label for the option', example: 'Main Campus' })
  label: string;

  @ApiProperty({ description: 'Value for the option', example: 'main_campus' })
  value: string;
}

/**
 * DTO for filters data in response
 */
export class FiltersDataDto {
  @ApiProperty({ 
    description: 'List of available property/venue options',
    type: [FilterOptionDto],
    example: [
      { label: 'Main Campus', value: 'main_campus' },
      { label: 'Guest House', value: 'guest_house' }
    ]
  })
  property: FilterOptionDto[];

  @ApiProperty({ 
    description: 'List of available block/building options',
    type: [FilterOptionDto],
    example: [
      { label: 'Block A', value: 'block_a' },
      { label: 'Block B', value: 'block_b' }
    ]
  })
  block: FilterOptionDto[];
}

/**
 * Main response DTO for room inventory list API - returns raw entity data
 */
export class RoomInventoryListResponseDto {
  @ApiProperty({ 
    description: 'Raw room inventory entities with all relations',
    example: [
      {
        id: 1,
        remainingOccupancy: 1,
        isReserved: false,
        roomStatus: 'AVAILABLE',
        occupiedStartsAt: null,
        occupiedEndsAt: null,
        remarks: null,
        reservedFor: null,
        createdAt: '2024-01-01T10:00:00Z',
        updatedAt: '2024-01-01T10:00:00Z',
        room: {
          id: 1,
          label: 'Deluxe Room A',
          roomNumber: '101',
          occupancy: 2,
          roomStatus: 'ACTIVE',
          roomType: 'DELUXE',
          bedType: 'DOUBLE',
          description: 'Comfortable deluxe room with AC',
          floor: {
            id: 1,
            label: 'Ground Floor',
            floorNumber: 'G'
          }
        },
        createdBy: {
          id: 1,
          firstName: 'Admin',
          lastName: 'User'
        },
        updatedBy: null,
        roomAllocations: []
      }
    ]
  })
  data: any[];

  @ApiProperty({ 
    description: 'Room inventory KPIs - array of status and count',
    type: [RoomStatusKpiDto]
  })
  kpis: RoomStatusKpiDto[];

  @ApiProperty({ 
    description: 'Filter dropdown options for property and block',
    type: FiltersDataDto
  })
  filters: FiltersDataDto;

  @ApiProperty({ description: 'Total records count', example: 100 })
  totalRecords: number;

  @ApiProperty({ description: 'Current page limit', example: 10 })
  limit: number;

  @ApiProperty({ description: 'Current page offset', example: 0 })
  offset: number;
}