import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsOptional, IsString, Max, Min } from 'class-validator';

/**
 * Data Transfer Object for updating an existing room allocation
 */
export class UpdateRoomAllocationDto {
  @ApiProperty({ 
    description: 'Program room inventory map ID',
    example: 1,
    type: 'integer',
    required: false
  })
  @IsOptional()
  @IsInt()
  programRoomInventoryMapId?: number;

  @ApiProperty({ 
    description: 'Registration ID to allocate the room to',
    example: 123,
    type: 'integer',
    required: false
  })
  @IsOptional()
  @IsInt()
  registrationId?: number;

  @ApiProperty({ 
    description: 'Bed position within the room',
    example: 1,
    type: 'integer',
    minimum: 1,
    maximum: 10,
    required: false
  })
  @IsOptional()
  @IsInt()
  @Min(1)
  @Max(10)
  bedPosition?: number;

  @ApiProperty({ 
    description: 'Additional remarks for the room allocation',
    example: 'Updated to preferred room',
    type: 'string',
    required: false
  })
  @IsOptional()
  @IsString()
  remarks?: string;
}