import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsNotEmpty, IsOptional, IsString, Max, Min } from 'class-validator';

/**
 * Data Transfer Object for creating a new room allocation
 */
export class CreateRoomAllocationDto {
  @ApiProperty({ 
    description: 'Program room inventory map ID',
    example: 1,
    type: 'integer'
  })
  @IsInt()
  @IsNotEmpty()
  programRoomInventoryMapId: number;

  @ApiProperty({ 
    description: 'Registration ID to allocate the room to',
    example: 123,
    type: 'integer'
  })
  @IsInt()
  @IsNotEmpty()
  registrationId: number;

  @ApiProperty({ 
    description: 'Bed position within the room',
    example: 1,
    type: 'integer',
    minimum: 1,
    maximum: 10,
    required: false
  })
  @IsOptional()
  @IsInt()
  @Min(1)
  @Max(10)
  bedPosition?: number;

  @ApiProperty({ 
    description: 'Additional remarks for the room allocation',
    example: 'Requested ground floor room',
    type: 'string',
    required: false
  })
  @IsOptional()
  @IsString()
  remarks?: string;
}