import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import {
  Program,
  ProgramSession,
  ProgramQuestion,
  Question,
  ProgramRegistration,
  RegistrationApproval,
  RegistrationCustomResponse,
  ProgramRegistrationFailure,
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationTravelInfo,
  RegistrationTravelPlan,
  RegistrationQuestionAnswer,
  User,
  Preference,
  CommunicationTrack,
  ProgramRegistrationSwap,
  ProgramRegistrationRmRating,
  ProgramRegistrationRecommendations,
  RegistrationApprovalTrack,
  CommunicationTemplates,
  LookupData,
} from 'src/common/entities';
import { UserProfileExtension } from 'src/common/entities/user-profile-extension.entity';
import { RegistrationController } from './registration.controller';
import { RegistrationService } from './registration.service';
import { RegistrationRepository } from './registration.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { PreferenceModule } from 'src/preference/preference.module';
import { ExcelService } from 'src/common/services/excel.service';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { ProgramRegistrationSwapRepository } from 'src/program-registration/repositories/program-registration-swap.repository';
import { ProgramRegistrationService } from 'src/program-registration/program-registration.service';
import { ProgramModule } from 'src/program/program.module';
import { RegistrationApprovalModule } from 'src/registration-approval/registration-approval.module';
import { CommunicationModule } from 'src/communication/communication.module';
import { UserProfileExtensionModule } from 'src/user-profile-extension/user-profile-extension.module';
import { AllocationClearingService } from 'src/common/services/allocation-clearing.service';
import { RoomInventoryModule } from 'src/room-inventory/room-inventory.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Program,
      ProgramSession,
      ProgramQuestion,
      Question,
      ProgramRegistration,
      RegistrationApproval,
      RegistrationCustomResponse,
      ProgramRegistrationFailure,
      RegistrationInvoiceDetail,
      RegistrationPaymentDetail,
      RegistrationTravelInfo,
      RegistrationTravelPlan,
      RegistrationQuestionAnswer,
      User,
      Preference,
      CommunicationTrack,
      ProgramRegistrationSwap,
      ProgramRegistrationRmRating,
      ProgramRegistrationRecommendations,
      RegistrationApprovalTrack,
      CommunicationTemplates,
      UserProfileExtension,
      LookupData
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => PreferenceModule),
    forwardRef(() => ProgramModule),
    forwardRef(() => CommunicationModule),
    forwardRef(() => RegistrationApprovalModule),
    forwardRef(() => UserProfileExtensionModule),
    forwardRef(() => RoomInventoryModule),
  ],
  controllers: [RegistrationController],
  providers: [
    RegistrationService,
    RegistrationRepository,
    CommonDataService,
    AppLoggerService,
    ExcelService,
    AwsS3Service,
    ProgramRegistrationRepository,
    ProgramRegistrationSwapRepository,
    ProgramRegistrationService,
    AllocationClearingService,
  ],
  exports: [RegistrationService, RegistrationRepository],
})
export class RegistrationModule {}
