import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsArray, IsBoolean, IsEnum, IsInt, IsOptional, IsString, ValidateNested } from 'class-validator';
import { RegistrationAnswerDto } from './create-registration.dto';
import { RegistrationStatusEnum } from 'src/common/enum/registration-status.enum';
import { ParentalFormStatusEnum } from 'src/common/enum/parental-form-status.enum';

export class UpdateRegistrationDto {
  @ApiProperty({ description: 'Program registration ID' })
  @IsInt()
  programRegistrationId: number;

  @ApiProperty({ description: 'Program ID' })
  @IsInt()
  programId: number;

  @ApiProperty({ description: 'Program Session ID', required: false })
  @IsOptional()
  @IsInt()
  programSessionId?: number;

  @ApiProperty({ enum: RegistrationStatusEnum, required: false })
  @IsOptional()
  @IsEnum(RegistrationStatusEnum)
  registrationStatus?: RegistrationStatusEnum;

  @ApiProperty({
    description: 'Form section ID being updated',
    example: 2,
    type: 'integer'
  })
  @IsOptional()
  @IsInt()
  formSectionId: number;

  @ApiProperty({ description: 'Flag to update user profile data', required: false, type: Boolean })
  @IsOptional()
  @IsBoolean()
  updateUserProfileData?: boolean;

  @ApiProperty({ description: 'Country code for mobile number', required: false })
  @IsOptional()
  @IsString()
  countryCode?: string;

  @ApiProperty({ type: [RegistrationAnswerDto] })
  @IsArray()
  @IsOptional()
  @ValidateNested({ each: true })
  @Type(() => RegistrationAnswerDto)
  answers: RegistrationAnswerDto[];

}

export class UpdateParentalConsentDto {
  @ApiProperty({
    description: 'Parental consent status',
    enum: [ParentalFormStatusEnum.COMPLETED],
  })
  @IsEnum(ParentalFormStatusEnum)
  parentalFormStatus: ParentalFormStatusEnum;

  @ApiProperty({ description: 'Parental consent form URL' })
  @IsString()
  parentalFormUrl: string;
}
