import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsEnum, IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { TravelStatusEnum } from 'src/common/enum/travel-status.enum';
import { CreateRegistrationTravelPlanDto } from './create-registration-travel-plan.dto';

export class UpdateRegistrationTravelPlanDto extends PartialType(
  OmitType(CreateRegistrationTravelPlanDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;

  @ApiProperty({ enum: TravelStatusEnum, required: false })
  @IsOptional()
  @IsEnum(TravelStatusEnum)
  travelPlanStatus?: TravelStatusEnum;
}
