import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RegistrationTravelInfo } from 'src/common/entities';
import { RegistrationTravelInfoService } from './registration-travel-info.service';
import { RegistrationTravelInfoController } from './registration-travel-info.controller';
import { RegistrationTravelInfoRepository } from './registration-travel-info.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationTravelInfo]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationTravelInfoController],
  providers: [RegistrationTravelInfoService, RegistrationTravelInfoRepository, CommonDataService, AppLoggerService],
  exports: [RegistrationTravelInfoService, RegistrationTravelInfoRepository],
})
export class RegistrationTravelInfoModule {}
