import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsEnum, IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { TravelStatusEnum } from 'src/common/enum/travel-status.enum';
import { CreateRegistrationTravelInfoDto } from './create-registration-travel-info.dto';

export class UpdateRegistrationTravelInfoDto extends PartialType(
  OmitType(CreateRegistrationTravelInfoDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;

  @ApiProperty({ enum: TravelStatusEnum, required: false })
  @IsOptional()
  @IsEnum(TravelStatusEnum)
  travelInfoStatus?: TravelStatusEnum;
}
