import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsEnum, IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { PaymentStatusEnum } from 'src/common/enum/payment-status.enum';
import { CreateRegistrationPaymentDetailDto } from './create-registration-payment-detail.dto';

export class UpdateRegistrationPaymentDetailDto extends PartialType(
  OmitType(CreateRegistrationPaymentDetailDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;

  @ApiProperty({ enum: PaymentStatusEnum, required: false })
  @IsOptional()
  @IsEnum(PaymentStatusEnum)
  paymentStatus?: PaymentStatusEnum;
}
