import { ApiProperty } from '@nestjs/swagger';
import { IsDateString, IsEnum, IsInt, IsNumber, IsOptional, IsString } from 'class-validator';
import { PaymentModeEnum } from 'src/common/enum/payment-mode.enum';
import { PaymentStatusEnum } from 'src/common/enum/payment-status.enum';

export class CreateRegistrationPaymentDetailDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty()
  @IsInt()
  programSessionId: number;

  @ApiProperty({ enum: PaymentModeEnum })
  @IsEnum(PaymentModeEnum)
  paymentMode: PaymentModeEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  taxAmount?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  tds?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  subTotal?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  razorpayId?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  offlineMeta?: Record<string, any>;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  originalAmount?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNumber()
  gstAmount?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  paymentDate?: Date;

  @ApiProperty({ enum: PaymentStatusEnum, required: false })
  @IsOptional()
  @IsEnum(PaymentStatusEnum)
  paymentStatus?: PaymentStatusEnum;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
