import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsEnum, IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { InvoiceStatusEnum } from 'src/common/enum/invoice-status.enum';
import { CreateRegistrationInvoiceDetailDto } from './create-registration-invoice-detail.dto';

export class UpdateRegistrationInvoiceDetailDto extends PartialType(
  OmitType(CreateRegistrationInvoiceDetailDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;

  @ApiProperty({ enum: InvoiceStatusEnum, required: false })
  @IsOptional()
  @IsEnum(InvoiceStatusEnum)
  invoiceStatus?: InvoiceStatusEnum;
}
