import { IsString, IsNumber, IsOptional, IsArray, IsNotEmpty, ArrayMinSize } from 'class-validator';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class CreateRegistrationPairDto {
  @IsString()
  @IsOptional()
  pairCode: string;

  @ApiProperty({ description: 'Program ID', example: 1 })
  @IsNumber()
  programId: number;

  @ApiPropertyOptional({ description: 'Sub-program ID', example: 2 })
  @IsOptional()
  @IsNumber()
  subProgramId?: number;

  @ApiPropertyOptional({
    description: 'Remarks about the pair',
    example: 'Special pairing for couples',
  })
  @IsOptional()
  @IsString()
  remarks?: string;

  @ApiProperty({ description: 'Registration IDs to be paired', example: [1, 2] })
  @IsArray()
  @IsNumber({}, { each: true })
  @ArrayMinSize(2)
  registrationIds: number[];

  @IsNumber()
  @IsOptional()
  createdBy: number;
}

export class CreateRegistrationGroupDto {
  @ApiProperty({ description: 'Group name', example: 'VIP Group' })
  @IsString()
  @IsNotEmpty()
  groupName: string;

  @ApiProperty({ description: 'Program ID', example: 1 })
  @IsNumber()
  programId: number;

  @ApiPropertyOptional({ description: 'Sub-program ID', example: 2 })
  @IsOptional()
  @IsNumber()
  subProgramId?: number;

  @ApiPropertyOptional({
    description: 'Remarks about the group',
    example: 'Special group for VIP participants',
  })
  @IsOptional()
  @IsString()
  remarks?: string;

  @ApiProperty({ description: 'Registration IDs to be grouped', example: [1, 2, 3, 4] })
  @IsArray()
  @IsNumber({}, { each: true })
  @ArrayMinSize(1)
  registrationIds: number[];

  @IsNumber()
  @IsOptional()
  createdBy: number;
}

export class AddRegistrationsToGroupDto {
  @ApiProperty({ description: 'Registration IDs to add to the group', example: [5, 6] })
  @IsArray()
  @IsNumber({}, { each: true })
  registrationIds: number[];

  @IsNumber()
  @IsOptional()
  updatedBy: number;
}

export class AddRegistrationsToPairDto {
  @ApiProperty({ description: 'Registration IDs to add to the pair', example: [3, 4] })
  @IsArray()
  @IsNumber({}, { each: true })
  registrationIds: number[];

  @ApiProperty({ description: 'User ID who is updating this pair' })
  @IsNumber()
  updatedBy: number;
}