import { ApiProperty } from '@nestjs/swagger';
import { IsBoolean, IsDateString, IsEnum, IsInt, IsOptional, IsString } from 'class-validator';
import { ApprovalStatusEnum } from 'src/common/enum/approval-status.enum';

export class CreateRegistrationApprovalDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty({ enum: ApprovalStatusEnum, required: false })
  @IsOptional()
  @IsEnum(ApprovalStatusEnum)
  approvalStatus?: ApprovalStatusEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  approvalDate?: Date;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  approvedBy?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  rejectionReason?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  reviewerComments?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsBoolean()
  autoApproved?: boolean;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
