import { ApiProperty, PartialType, OmitType } from '@nestjs/swagger';
import { CreateQuestionDto } from './create-question.dto';
import { IsInt, IsNotEmpty } from 'class-validator';

export class UpdateQuestionDto extends PartialType(
  OmitType(CreateQuestionDto, ['createdBy', 'updatedBy'] as const)
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty({ message: 'updatedBy is required.' })
  updatedBy: number;
}