import { ApiProperty } from '@nestjs/swagger';
import { IsInt, IsNotEmpty, IsArray, ArrayNotEmpty } from 'class-validator';

export class CreateQuestionOptionDto {
  @ApiProperty({ description: 'ID of the question' })
  @IsInt({ message: 'The questionId must be a valid integer.' })
  @IsNotEmpty({ message: 'The questionId is required.' })
  questionId: number;

  @ApiProperty({ description: 'Array of option IDs' })
  @IsArray({ message: 'The optionIds must be an array.' })
  @ArrayNotEmpty({ message: 'The optionIds array must not be empty.' })
  @IsInt({ each: true, message: 'Each optionId must be a valid integer.' })
  optionIds: number[];

  @ApiProperty({ description: 'ID of the user creating the record' })
  @IsInt({ message: 'The createdBy field must be a valid integer.' })
  @IsNotEmpty({ message: 'The createdBy field is required.' })
  createdBy: number;

  @ApiProperty({ description: 'ID of the user updating the record' })
  @IsInt({ message: 'The updatedBy field must be a valid integer.' })
  @IsNotEmpty({ message: 'The updatedBy field is required.' })
  updatedBy: number;
}