import { ApiProperty, PartialType, OmitType } from '@nestjs/swagger';
import { CreateProgramDto, GroupedProgramDto } from './create-program.dto';
import { IsOptional, IsNumber, IsArray, ValidateNested, IsInt } from 'class-validator';
import { Type } from 'class-transformer';

export class UpdateProgramDto extends PartialType(
  OmitType(CreateProgramDto, ['createdBy'] as const)
) {
  @ApiProperty({ description: 'Updated by user ID', example: 1 })
  @IsNumber()
  updatedBy: number;

  @ApiProperty({ 
    description: 'Grouped programs (only for primary programs)', 
    type: [GroupedProgramDto], 
    required: false 
  })
  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => GroupedProgramDto)
  groupedPrograms?: GroupedProgramDto[];

  @ApiProperty({ 
    description: 'Program IDs to be deleted (for grouped programs)', 
    type: [Number], 
    required: false,
    example: [123, 456]
  })
  @IsOptional()
  @IsArray()
  @IsInt({ each: true })
  deletedProgramIds?: number[];
}