import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ProgramType, User } from 'src/common/entities';
import { ProgramTypeService } from './program-type.service';
import { ProgramTypeController } from './program-type.controller';
import { ProgramTypeRepository } from './program-type.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([ProgramType, User]), 
    forwardRef(() => AuthModule), 
    forwardRef(() => UserModule)
  ],
  controllers: [ProgramTypeController],
  providers: [ProgramTypeService, ProgramTypeRepository, CommonDataService],
  exports: [ProgramTypeService, ProgramTypeRepository],
})
export class ProgramTypeModule {}