import { ApiProperty, PartialType, OmitType } from '@nestjs/swagger';
import { CreateProgramTypeDto } from './create-program-type.dto';
import { IsInt, IsNotEmpty } from 'class-validator';

/**
 * DTO for updating an existing ProgramType.
 * Inherits from CreateProgramTypeDto and makes all fields optional except updatedBy.
 */
export class UpdateProgramTypeDto extends PartialType(
  OmitType(CreateProgramTypeDto, ['createdBy', 'updatedBy'] as const)
) {
  @ApiProperty({ description: 'Updated by user ID' })
  @IsInt({ message: 'The updatedBy field must be a valid integer.' })
  @IsNotEmpty({ message: 'updatedBy is required.' })
  updatedBy: number;
}