import { Module, forwardRef } from '@nestjs/common';
import { ProgramSessionService } from './program-session.service';
import { ProgramSessionController } from './program-session.controller';
import { ProgramSessionRepository } from './program-session.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Program, ProgramSession, User } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([ProgramSession, Program, User]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [ProgramSessionController],
  providers: [ProgramSessionService, ProgramSessionRepository, CommonDataService, AppLoggerService],
  exports: [ProgramSessionService, ProgramSessionRepository],
})
export class ProgramSessionModule {}
