import { Module, forwardRef } from '@nestjs/common';
import { ProgramQuestionService } from './program-question.service';
import { ProgramQuestionController } from './program-question.controller';
import { ProgramQuestionRepository } from './program-question.repository';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Question, User, Program, ProgramQuestion, ProgramSession, FormSection, Option, QuestionOptionMap, OptionCategory } from 'src/common/entities';
import { UserModule } from 'src/user/user.module';
import { AuthModule } from 'src/auth/auth.module';
import { CommonDataService } from 'src/common/services/commonData.service';
import { QuestionRepository } from 'src/question/question.repository';
import { OptionRepository } from 'src/option/option.repository';
import { QuestionOptionRepository } from 'src/question-option/question-option.repository';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Question,
      User,
      Program,
      ProgramQuestion,
      ProgramSession,
      FormSection,
      Option,
      QuestionOptionMap,
      OptionCategory
    ]),
    forwardRef(() => UserModule),
    forwardRef(() => AuthModule)
  ],
  controllers: [ProgramQuestionController],
  providers: [
    ProgramQuestionService,
    ProgramQuestionRepository,
    CommonDataService,
    QuestionRepository,
    OptionRepository,
    QuestionOptionRepository
  ],
  exports: [
    ProgramQuestionService,
    ProgramQuestionRepository
  ],
})
export class ProgramQuestionModule {}