import { forwardRef, Module } from '@nestjs/common';
import { PaymentService } from './payment.service';
import { PaymentController } from './payment.controller';
import { InvoiceService } from 'src/invoice/invoice.service';
import { PaymentRepository } from './payment.repository';
import { TypeOrmModule } from '@nestjs/typeorm';
import { 
  CommunicationTrack,
  Option,
  Preference,
  Program, 
  ProgramQuestion, 
  ProgramRegistration, 
  ProgramRegistrationFailure, 
  ProgramRegistrationSwap, 
  ProgramSession, 
  Question, 
  RegistrationApproval, 
  RegistrationCustomResponse, 
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationPaymentDetailsHistory,
  RegistrationQuestionAnswer,
  ProgramRegistrationRmRating,
  RegistrationTravelPlan,
  RegistrationTravelInfo,
  ProgramRegistrationRecommendations,
  RegistrationApprovalTrack,
  CommunicationTemplates,
  LookupData,
} from 'src/common/entities';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { RegistrationService } from 'src/registration/registration.service';
import { RegistrationRepository } from 'src/registration/registration.repository';
import { PreferenceModule } from 'src/preference/preference.module';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { ExcelService } from 'src/common/services/excel.service';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ProgramRegistrationSwapRepository } from 'src/program-registration/repositories/program-registration-swap.repository';
import { ProgramRegistrationModule } from 'src/program-registration/program-registration.module';
import { CommunicationModule } from 'src/communication/communication.module';
import { PaymentEditRequestService } from './services/payment-edit-request.service';
import { PaymentEditRequestRepository } from './repositories/payment-edit-request.repository';
import { PaymentEditRequest } from 'src/common/entities/payment-edit-request.entity';
import { RegistrationPaymentDetailService } from 'src/registration-payment-detail/registration-payment-detail.service';
import { RegistrationInvoiceBasicHistory } from 'src/common/entities/registration-invoice-basic-history.entity';
import { RegistrationInvoiceEinvoiceHistory } from 'src/common/entities/registration-invoice-einvoice-history.entity';
import { InvoiceEinvoiceHistoryService } from 'src/invoice/services/invoice-einvoice-history.service';
import { UserProfileExtensionModule } from 'src/user-profile-extension/user-profile-extension.module';
import { InvoiceRepository } from 'src/invoice/invoice.repository';
import { RegistrationApprovalModule } from 'src/registration-approval/registration-approval.module';
import { AllocationClearingService } from 'src/common/services/allocation-clearing.service';
import { RoomInventoryModule } from 'src/room-inventory/room-inventory.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      RegistrationPaymentDetail,
      RegistrationPaymentDetailsHistory,
      RegistrationInvoiceDetail,
      ProgramRegistration,
      ProgramSession,
      Program,
      Question,
      Option,
      RegistrationApproval,
      ProgramQuestion,
      RegistrationCustomResponse,
      ProgramRegistrationFailure,
      CommunicationTrack,
      Preference,
      ProgramRegistrationSwap,
      RegistrationQuestionAnswer,
      ProgramRegistrationRmRating,
      ProgramRegistrationRecommendations,
      CommunicationTemplates,
      RegistrationTravelPlan,
      RegistrationTravelInfo,
      RegistrationApprovalTrack,
      PaymentEditRequest,
      RegistrationInvoiceBasicHistory,
      RegistrationInvoiceEinvoiceHistory,
      LookupData
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => PreferenceModule),
    forwardRef(() => ProgramRegistrationModule),
    forwardRef(() => CommunicationModule),
    forwardRef(() => UserProfileExtensionModule),
    forwardRef(() => RegistrationApprovalModule),
    forwardRef(() => RoomInventoryModule),
  ],
  controllers: [PaymentController],
  providers: [
    PaymentService, 
    InvoiceService, 
    PaymentRepository, 
    CommonDataService, 
    AppLoggerService,
    RegistrationService,
    RegistrationRepository,
    ProgramRegistrationRepository,
    ExcelService,
    AwsS3Service,
    ProgramRegistrationSwapRepository,
    InvoiceEinvoiceHistoryService,
    PaymentEditRequestService,
    PaymentEditRequestRepository,
    RegistrationPaymentDetailService,
    InvoiceRepository,
    AllocationClearingService,
  ],
  exports: [PaymentService, PaymentRepository, ExcelService],
})
export class PaymentModule {}