// import { Test, TestingModule } from '@nestjs/testing';
// import { OptionService } from './option.service';
// import { Option } from 'src/common/entities/option.entity';
// import { OptionCategory } from 'src/common/entities/option-category.entity';
// import { User } from 'src/common/entities/user.entity';
// import { Repository } from 'typeorm';
// import { getRepositoryToken } from '@nestjs/typeorm';
// import { CommonDataService } from 'src/common/services/commonData.service';
// import { NotFoundException, BadRequestException } from '@nestjs/common';
// import { CreateOptionDto } from './dto/create-option.dto';
// import { UpdateOptionDto } from './dto/update-option.dto';
// import { OptionType } from 'src/common/enum/option-type.enum';

// const mockRepo = () => ({
//   findOne: jest.fn(),
//   find: jest.fn(),
//   count: jest.fn(),
//   save: jest.fn(),
//   remove: jest.fn(),
// });

// const mockCommonDataService = () => ({
//   get: jest.fn(),
// });

// describe('OptionService', () => {
//   let service: OptionService;
//   let optionRepo: jest.Mocked<Repository<Option>>;
//   let categoryRepo: jest.Mocked<Repository<OptionCategory>>;
//   let userRepo: jest.Mocked<Repository<User>>;
//   let commonDataService: ReturnType<typeof mockCommonDataService>;

//   beforeEach(async () => {
//     const module: TestingModule = await Test.createTestingModule({
//       providers: [
//         OptionService,
//         { provide: getRepositoryToken(Option), useFactory: mockRepo },
//         { provide: getRepositoryToken(OptionCategory), useFactory: mockRepo },
//         { provide: getRepositoryToken(User), useFactory: mockRepo },
//         { provide: CommonDataService, useFactory: mockCommonDataService },
//       ],
//     }).compile();

//     service = module.get<OptionService>(OptionService);
//     optionRepo = module.get(getRepositoryToken(Option));
//     categoryRepo = module.get(getRepositoryToken(OptionCategory));
//     userRepo = module.get(getRepositoryToken(User));
//     commonDataService = module.get(CommonDataService);
//   });

//   describe('create', () => {
//     const dto: CreateOptionDto = {
//       name: 'Test Option',
//       type: OptionType.STRING,
//       categoryId: 1,
//       createdBy: 1,
//       updatedBy: 1,
//       status: null,
//     };

//     it('should throw NotFound if category not found', async () => {
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.create(dto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw NotFound if user not found', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       userRepo.findOne.mockResolvedValue(null);
//       await expect(service.create(dto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw BadRequest if option exists', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       optionRepo.findOne.mockResolvedValue({ id: 99 } as any);
//       await expect(service.create(dto)).rejects.toThrow(BadRequestException);
//     });

//     it('should save a new option successfully', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       optionRepo.findOne.mockResolvedValue(null);
//       optionRepo.save.mockResolvedValue(
//         { id: 1, ...dto } as any,
//       );

//       const result = await service.create(dto);
//       expect(result).toEqual({ id: 1, ...dto });
//     });
//   });
//   describe('findAll', () => {
//     it('should return paginated options', async () => {
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Option A' }]);
//       optionRepo.count.mockResolvedValue(1);

//       const result = await service.findAll(10, 0, 'Option',[],{'status': 'draft'});
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });

//     // find all with search limit and offset 
//     it('should return paginated options with search', async () => {
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Option A' }]);
//       optionRepo.count.mockResolvedValue(1);

//       const result = await service.findAll(10, 0, '',[],{'status': 'draft'});
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });
//   });
//   describe('findOne', () => {
//     it('should throw NotFound if option does not exist', async () => {
//       optionRepo.findOne.mockResolvedValue(null);
//       await expect(service.findOne(99)).rejects.toThrow(NotFoundException);
//     });

//     it('should return the option if found', async () => {
//       const option = { id: 1, name: 'Test' };
//       optionRepo.findOne.mockResolvedValue(option as any);
//       const result = await service.findOne(1);
//       expect(result).toEqual(option);
//     });
//   });

//   describe('update', () => {
//     const updateDto: UpdateOptionDto = {
//       name: 'Updated',
//       type: OptionType.STRING,
//       categoryId: 2,
//       updatedBy: 1,
//     };

//     it('should throw NotFound if option not found', async () => {
//       optionRepo.findOne.mockResolvedValue(null);
//       await expect(service.update(1, updateDto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw NotFound if category not found', async () => {
//       optionRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.update(1, updateDto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw NotFound if user not found', async () => {
//       optionRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       categoryRepo.findOne.mockResolvedValue({ id: 2 } as any);
//       userRepo.findOne.mockResolvedValue(null);
//       await expect(service.update(1, updateDto)).rejects.toThrow(NotFoundException);
//     });
//     it('should throw BadRequest if update fails due to invalid data', async () => {
//       const option = { id: 1, name: 'Old', save: jest.fn() };
//       optionRepo.findOne.mockResolvedValue(option as any);
//       categoryRepo.findOne.mockResolvedValue({ id: 2 } as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);

//       optionRepo.save.mockRejectedValue(new Error('Invalid data'));

//       await expect(service.update(1, updateDto)).rejects.toThrow(BadRequestException);
//     });

//     // if option exists with same name and type
//     it('should throw BadRequest if option exists with same name and type', async () => {
//       const option = { id: 1, name: 'Old', save: jest.fn() };
//       optionRepo.findOne.mockResolvedValue(option as any);
//       categoryRepo.findOne.mockResolvedValue({ id: 2 } as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       optionRepo.findOne.mockResolvedValue({ id: 2 } as any);

//       await expect(service.update(1, updateDto)).rejects.toThrow(BadRequestException);
//     });

//     it('should throw BadRequest if create fails due to invalid data', async () => {
//       const dto: CreateOptionDto = {
//         name: 'Test Option',
//         type: OptionType.STRING,
//         categoryId: 1,
//         createdBy: 1,
//         updatedBy: 1,
//         status: null,
//       };

//       categoryRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       optionRepo.findOne.mockResolvedValue(null);

//       optionRepo.save.mockRejectedValue(new Error('Invalid data'));

//       await expect(service.create(dto)).rejects.toThrow(BadRequestException);
//     });

//     it('should throw BadRequest if remove fails due to database error', async () => {
//       const option = { id: 1, name: 'Test' };
//       optionRepo.findOne.mockResolvedValue(option as any);
//       optionRepo.remove.mockRejectedValue(new Error('Database error'));

//       await expect(service.remove(1)).rejects.toThrow(BadRequestException);
//     });
//     it('should throw NotFound if option not found', async () => {
//       optionRepo.findOne.mockResolvedValue(null);
//       await expect(service.remove(1)).rejects.toThrow(NotFoundException);
//     });

//     it('should delete and return the option', async () => {
//       const option = { id: 1, name: 'Test' };
//       optionRepo.findOne.mockResolvedValue(option as any);
//       optionRepo.remove.mockResolvedValue(option as any);
//       const result = await service.remove(1);
//       expect(result).toEqual(option);
//     });
//   });
// });
