
// dto/update-option.dto.ts
import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { CreateOptionDto } from './create-option.dto'; 
import { IsInt, IsNotEmpty } from 'class-validator';

export class UpdateOptionDto extends PartialType(
    OmitType(CreateOptionDto, ['createdBy','updatedBy'] as const)
  ) {
    @ApiProperty()
    @IsInt()
    @IsNotEmpty({ message: 'updatedBy is required.' })
    updatedBy: number;
  }