// import { Test, TestingModule } from '@nestjs/testing';
// import { OptionCategoryService } from './option-category.service';
// import { OptionCategory } from 'src/common/entities/option-category.entity';
// import { User } from 'src/common/entities/user.entity';
// import { Option } from 'src/common/entities/option.entity';
// import { Repository } from 'typeorm';
// import { getRepositoryToken } from '@nestjs/typeorm';
// import { CommonDataService } from 'src/common/services/commonData.service';
// import { NotFoundException, BadRequestException, InternalServerErrorException } from '@nestjs/common';
// import { CreateOptionCategoryDto } from './dto/create-option-category.dto';
// import { UpdateOptionCategoryDto } from './dto/update-option-category.dto';

// const mockRepo = () => ({
//   findOne: jest.fn(),
//   find: jest.fn(),
//   count: jest.fn(),
//   save: jest.fn(),
//   remove: jest.fn(),
// });

// const mockCommonDataService = () => ({
//   get: jest.fn(),
// });

// describe('OptionCategoryService', () => {
//   let service: OptionCategoryService;
//   let categoryRepo: jest.Mocked<Repository<OptionCategory>>;
//   let userRepo: jest.Mocked<Repository<User>>;
//   let optionRepo: jest.Mocked<Repository<Option>>;
//   let commonDataService: ReturnType<typeof mockCommonDataService>;

//   beforeEach(async () => {
//     const module: TestingModule = await Test.createTestingModule({
//       providers: [
//         OptionCategoryService,
//         { provide: getRepositoryToken(OptionCategory), useFactory: mockRepo },
//         { provide: getRepositoryToken(User), useFactory: mockRepo },
//         { provide: getRepositoryToken(Option), useFactory: mockRepo },
//         { provide: CommonDataService, useFactory: mockCommonDataService },
//       ],
//     }).compile();

//     service = module.get<OptionCategoryService>(OptionCategoryService);
//     categoryRepo = module.get(getRepositoryToken(OptionCategory));
//     userRepo = module.get(getRepositoryToken(User));
//     optionRepo = module.get(getRepositoryToken(Option));
//     commonDataService = module.get(CommonDataService);
//   });

//   describe('create', () => {
//     const dto: CreateOptionCategoryDto = {
//       name: 'Test Category',
//       createdBy: 1,
//       updatedBy: 1,
//     };

//     it('should throw NotFound if creator not found', async () => {
//       userRepo.findOne.mockResolvedValueOnce(null);
//       await expect(service.create(dto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw NotFound if updater not found', async () => {
//       userRepo.findOne.mockResolvedValueOnce({ id: 1 } as any).mockResolvedValueOnce(null);
//       await expect(service.create(dto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw BadRequest if category with the same name exists', async () => {
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       categoryRepo.findOne.mockResolvedValue({ id: 99 } as any);
//       await expect(service.create(dto)).rejects.toThrow(BadRequestException);
//     });

//     it('should save a new category successfully', async () => {
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       categoryRepo.findOne.mockResolvedValue(null);
//       categoryRepo.save.mockResolvedValue({ id: 1, ...dto } as any);

//       const result = await service.create(dto);
//       expect(result).toEqual({ id: 1, ...dto });
//     });
//   });

//   describe('findAll', () => {
//     it('should return paginated categories', async () => {
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Category A' }]);
//       categoryRepo.count.mockResolvedValue(1);

//       const result = await service.findAll(10, 0, 'Category');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });

//     it('should return paginated categories with search', async () => {
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Category A' }]);
//       categoryRepo.count.mockResolvedValue(1);

//       const result = await service.findAll(10, 0, '');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });

//     it('should return all categories when searchText is empty', async () => {
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Category A' }]);
//       categoryRepo.count.mockResolvedValue(1);
    
//       const result = await service.findAll(10, 0, '');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });
//   });

//   describe('findOne', () => {
//     it('should throw NotFound if category does not exist', async () => {
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.findOne(99)).rejects.toThrow(NotFoundException);
//     });

//     it('should return the category if found', async () => {
//       const category = { id: 1, name: 'Test' };
//       categoryRepo.findOne.mockResolvedValue(category as any);
//       const result = await service.findOne(1);
//       expect(result).toEqual(category);
//     });
//   });

//   describe('findByCategoryWiseOptionsById', () => {
//     it('should throw NotFound if category does not exist', async () => {
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.findByCategoryWiseOptionsById(1, 10, 0, 'Option')).rejects.toThrow(NotFoundException);
//     });
  
//     it('should return paginated options for a category', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1, name: 'Category A' } as any);
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Option A' }]);
//       optionRepo.count.mockResolvedValue(1);
  
//       const result = await service.findByCategoryWiseOptionsById(1, 10, 0, 'Option');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });
  
//     it('should return paginated options without search text', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1, name: 'Category A' } as any);
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Option A' }]);
//       optionRepo.count.mockResolvedValue(1);
  
//       const result = await service.findByCategoryWiseOptionsById(1, 10, 0, '');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });

//     it('should return all options for a category when searchText is empty', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1, name: 'Category A' } as any);
//       commonDataService.get.mockResolvedValue([{ id: 1, name: 'Option A' }]);
//       optionRepo.count.mockResolvedValue(1);
    
//       const result = await service.findByCategoryWiseOptionsById(1, 10, 0, '');
//       expect(result.data.length).toBe(1);
//       expect(result.pagination.totalRecords).toBe(1);
//     });
//   });

//   describe('update', () => {
//     const updateDto: UpdateOptionCategoryDto = {
//       name: 'Updated Category',
//       updatedBy: 1,
//     };

//     it('should throw NotFound if category not found', async () => {
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.update(1, updateDto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw NotFound if updater not found', async () => {
//       categoryRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       userRepo.findOne.mockResolvedValue(null);
//       await expect(service.update(1, updateDto)).rejects.toThrow(NotFoundException);
//     });

//     it('should throw BadRequest if category with the same name exists', async () => {
//       // Mock the userRepo to return a valid user
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
    
//       // Mock categoryRepo.findOne to simulate an existing category with the same name
//       categoryRepo.findOne.mockResolvedValueOnce({ id: 1, name: 'Existing Category' } as any); // Category to be updated
//       categoryRepo.findOne.mockResolvedValueOnce({ id: 2, name: 'Existing Category' } as any); // Another category with the same name
    
//       // Mock the updateDto with the same name as the existing category
//       const updateDto: UpdateOptionCategoryDto = {
//         name: 'Existing Category', // This should cause the BadRequestException
//         updatedBy: 1,
//       };
    
//       // Simulate the update method throwing the error
//       try {
//         await service.update(1, updateDto);  // ID of the category to update
//       } catch (error) {
//         expect(error).toBeInstanceOf(BadRequestException);
//         expect(error.response).toBe('Category with this name already exists');
//       }
//     });
    
    

//     it('should update and return the category', async () => {
//       const category = { id: 1, name: 'Old Category' };
//       categoryRepo.findOne.mockResolvedValue(category as any);
//       userRepo.findOne.mockResolvedValue({ id: 1 } as any);
//       categoryRepo.save.mockResolvedValue({ id: 1, ...updateDto } as any);

//       const result = await service.update(1, updateDto);
//       expect(result).toEqual({ id: 1, ...updateDto });
//     });
//   });

//   describe('remove', () => {
//     it('should throw NotFound if category not found', async () => {
//       categoryRepo.findOne.mockResolvedValue(null);
//       await expect(service.remove(1)).rejects.toThrow(NotFoundException);
//     });

//     it('should delete and return the category', async () => {
//       const category = { id: 1, name: 'Test' };
//       categoryRepo.findOne.mockResolvedValue(category as any);
//       categoryRepo.remove.mockResolvedValue(category as any);

//       const result = await service.remove(1);
//       expect(result).toEqual(category);
//     });
//     it('should throw InternalServerError if remove fails', async () => {
//       const category = { id: 1, name: 'Test' };
//       categoryRepo.findOne.mockResolvedValue(category as any);
//       categoryRepo.remove.mockRejectedValue(new Error('Database error')); // This simulates the failure
    
//       await expect(service.remove(1)).rejects.toThrow(InternalServerErrorException);
//     });
    
//   });
// });