import { ApiProperty, PartialType, OmitType } from '@nestjs/swagger';
import { CreateOptionCategoryDto } from './create-option-category.dto';
import { IsInt, IsNotEmpty } from 'class-validator';

export class UpdateOptionCategoryDto extends PartialType(
  OmitType(CreateOptionCategoryDto, ['createdBy', 'updatedBy'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty({ message: 'updatedBy is required.' })
  updatedBy: number;
}
