import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { RegistrationInvoiceDetail } from 'src/common/entities';
import { Repository } from 'typeorm';

@Injectable()
export class InvoiceRepository {
  private invoices: any[] = [];

  constructor(
     @InjectRepository(RegistrationInvoiceDetail)
    private readonly invoiceService: Repository<RegistrationInvoiceDetail>, // Replace with actual service type if available
  ) {}

  findAll() {
    return this.invoices;
  }

  findById(id: number) {
    return this.invoices.find(invoice => invoice.id === id);
  }

  create(invoice: any) {
    const newInvoice = { id: this.invoices.length + 1, ...invoice };
    this.invoices.push(newInvoice);
    return newInvoice;
  }

  update(id: number, updatedInvoice: any) {
    const index = this.invoices.findIndex(invoice => invoice.id === id);
    if (index !== -1) {
      this.invoices[index] = { ...this.invoices[index], ...updatedInvoice };
      return this.invoices[index];
    }
    return null;
  }

  delete(id: number) {
    const index = this.invoices.findIndex(invoice => invoice.id === id);
    if (index !== -1) {
      return this.invoices.splice(index, 1)[0];
    }
    return null;
  }
  async findByRegistrationId(registrationId: number) {
    return this.invoiceService.findOne({
      where: { registrationId },
      relations: [
        'registration',
        'registration.program',
        'registration.allocatedProgram',
        'registration.allocatedSession',
        'registration.user'
      ],
    });
  }
}