import { forwardRef, Module } from '@nestjs/common';
import { InvoiceService } from './invoice.service';
import { InvoiceController } from './invoice.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTemplates, CommunicationTrack, ProgramRegistration, RegistrationInvoiceDetail, RegistrationPaymentDetail } from 'src/common/entities';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { PreferenceModule } from 'src/preference/preference.module';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { CommunicationModule } from 'src/communication/communication.module';
import { InvoiceEinvoiceHistoryService } from './services/invoice-einvoice-history.service';
import { RegistrationInvoiceBasicHistory } from 'src/common/entities/registration-invoice-basic-history.entity';
import { RegistrationInvoiceEinvoiceHistory } from 'src/common/entities/registration-invoice-einvoice-history.entity';
import { InvoiceRepository } from './invoice.repository';
import { RegistrationApprovalModule } from 'src/registration-approval/registration-approval.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      RegistrationInvoiceDetail,
      RegistrationPaymentDetail,
      ProgramRegistration,
      CommunicationTrack,
      CommunicationTemplates,
      RegistrationInvoiceBasicHistory,
      RegistrationInvoiceEinvoiceHistory,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => PreferenceModule),
    forwardRef(() => CommunicationModule),
    forwardRef(() => RegistrationApprovalModule),
  ],
  controllers: [InvoiceController],
  providers: [
    InvoiceService,
    CommonDataService,
    AppLoggerService,
    AwsS3Service,
    InvoiceEinvoiceHistoryService,
    InvoiceRepository,
  ],
  exports: [InvoiceService, InvoiceRepository],
})
export class InvoiceModule {}
