import { ApiProperty } from '@nestjs/swagger';

export class CreateInvoiceDto {}

export class BillingAdderess {
  @ApiProperty()
  attention: string;

  @ApiProperty()
  address: string;

  @ApiProperty()
  street2: string;

  @ApiProperty()
  state_code: string;

  @ApiProperty()
  city: string;

  @ApiProperty()
  state: string;

  @ApiProperty()
  zip: number;

  @ApiProperty()
  country: string;

  @ApiProperty()
  phone: number;
}

export class EInvoiceContactData {
  @ApiProperty()
  contact_name: string;

  @ApiProperty()
  company_name: string;

  @ApiProperty()
  currency_code: string;

  @ApiProperty({ type: BillingAdderess })
  billing_address: BillingAdderess;

  @ApiProperty()
  gst_no: string;

  @ApiProperty()
  gst_treatment: string;
}

export class EInvoiceLineItem {
  @ApiProperty()
  description: string;

  @ApiProperty()
  rate: number;

  @ApiProperty()
  quantity: number;

  @ApiProperty()
  unit: string;

  @ApiProperty()
  product_type: string;

  @ApiProperty()
  hsn_or_sac: number;

  @ApiProperty()
  tax_name: string;
}

export class EInvoiceData {
  @ApiProperty()
  place_of_supply: string;

  @ApiProperty()
  invoice_number: string;

  @ApiProperty()
  date: string;

  @ApiProperty()
  discount: number;

  @ApiProperty()
  is_discount_before_tax: boolean;

  @ApiProperty()
  discount_type: string;

  @ApiProperty()
  shipping_charge: number;

  @ApiProperty({ type: [EInvoiceLineItem] })
  line_items: EInvoiceLineItem[];

  @ApiProperty()
  adjustment: number;

  @ApiProperty()
  adjustment_description: string;

  @ApiProperty()
  notes: string;

  @ApiProperty()
  terms: string;

  @ApiProperty()
  subject_content: string;

  @ApiProperty()
  seller_gstin: string;

  @ApiProperty()
  is_inclusive_tax: boolean;

  @ApiProperty()
  tax_rounding: string;

  @ApiProperty()
  shipping_charge_tax_name: string;

  @ApiProperty()
  shipping_charge_sac_code: string;

  @ApiProperty()
  is_reverse_charge_applied: boolean;

  @ApiProperty()
  is_customer_liable_for_tax: boolean;

  @ApiProperty()
  is_export_with_payment: boolean;
}

export class EInvoiceResponse {
  @ApiProperty({ type: EInvoiceContactData })
  contact: EInvoiceContactData;

  @ApiProperty({ type: EInvoiceData })
  invoice: EInvoiceData;
}
