import { Module, forwardRef } from '@nestjs/common';
import { FormSectionService } from './form-section.service';
import { FormSectionController } from './form-section.controller';
import { FormSectionRepository } from './form-section.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { FormSection } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([FormSection]),forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [FormSectionController],
  providers: [FormSectionService, FormSectionRepository, CommonDataService],
  exports: [FormSectionService, FormSectionRepository],
})
export class FormSectionModule {}
