import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { FormSchemaController } from './form-schema.controller';
import { FormSchemaService } from './form-schema.service';
import { 
  FormSection, 
  Option,
  Question,
  QuestionOptionMap,
  Program,
  ProgramQuestion, 
  User,
  OptionCategory
} from 'src/common/entities';
import { QuestionRepository } from 'src/question/question.repository';
import { FormSectionRepository } from 'src/form-section/form-section.repository';
import { ProgramQuestionRepository } from 'src/program-question/program-question.repository';
import { ProgramRepository } from 'src/program/program.repository';
import { OptionRepository } from 'src/option/option.repository';
import { QuestionOptionRepository } from 'src/question-option/question-option.repository';
import { ConfigModule } from '@nestjs/config';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { UserModule } from 'src/user/user.module';
import { ProgramModule } from 'src/program/program.module';
import { ProgramQuestionModule } from 'src/program-question/program-question.module';

@Module({
  imports: [
    ConfigModule,
    forwardRef(() => UserModule),
    ProgramModule,
    ProgramQuestionModule,
    TypeOrmModule.forFeature([
      FormSection,
      Option,
      Question,
      QuestionOptionMap,
      Program,
      ProgramQuestion,
      User,
      OptionCategory
    ])
  ],
  controllers: [FormSchemaController],
  providers: [
    FormSchemaService,
    QuestionRepository,
    FormSectionRepository,
    OptionRepository,
    QuestionOptionRepository,
    CommonDataService,
    AppLoggerService
  ],
  exports: [FormSchemaService]
})
export class FormSchemaModule {}