import { InifniNotFoundException } from 'src/common/exceptions/infini-notfound-exception';
import { userConstMessages } from 'src/common/constants/strings-constants';

/**
 * Extract and validate user from request object.
 * Ensures that user exists and has a valid ID before proceeding with operations.
 * @param req - Request object containing user data.
 * @returns User object with validated ID.
 * @throws InifniNotFoundException if user is not found or invalid.
 */
export function extractAndValidateUser(req: any): any {
  const user = req.user;
  if (!user || !user.id) {
    throw new InifniNotFoundException(
      userConstMessages.USER_ID_NOT_FOUND,
      null,
      null,
      user?.id || null
    );
  }
  return user;
}

/**
 * Extract user ID from request object.
 * Provides a simplified method to get just the user ID for operations that don't need the full user object.
 * @param req - Request object containing user data.
 * @returns User ID as number.
 * @throws InifniNotFoundException if user ID is not found.
 */
export function extractUserId(req: any): number {
  const userId = req.user?.id;
  if (!userId) {
    throw new InifniNotFoundException(
      userConstMessages.USER_ID_NOT_FOUND,
      null,
      null,
      userId || null
    );
  }
  return userId;
}