import { Injectable } from '@nestjs/common';
import { Response } from 'express';
import { HttpStatus } from '@nestjs/common';

@Injectable()
export class ResponseService {
  /**
   * Method to send a success response
   * @param res - Express Response object
   * @param message - Success message
   * @param data - Optional data to include in the response
   * @param statusCode - Optional HTTP status code (default: HttpStatus.OK)
   */
  async success(
    res: Response,
    message: string,
    data?: object,
    statusCode: number = HttpStatus.OK,
  ): Promise<void> {
    const response: any = {
      statusCode,
      message,
    };

    // Add the data field only if data is provided
    if (data) {
      response.data = data;
    }

    res.status(statusCode).json(response);
  }
}
