// interfaces

export interface IInfiniException extends Error {
    code: string;
    message: string;
    error?: Error | null;
    details?: any;
}

/**
 * Basic filter configuration interface
 * Defines the structure for filter options in various modules
 */
export interface FilterConfig {
    key: string;
    label: string;
    type: string;
    sortable: boolean;
    filterable: boolean;
    order: number;
    options: any[];
    placeholder?: string;
}

/**
 * Type alias for room allocation filter configuration
 * Array of filter configurations used in room allocation module
 */
export type RoomAllocationFilterConfig = FilterConfig[];