export const ERROR_MESSAGES = {
  Q_NF_001: 'Creator not found with ID {0} with name {1}',
  Q_NF_002: 'Updator not found with ID {0}',
  Q_NF_003: 'Question not found with ID {0}',
  Q_NF_004: 'Question not found or not published for ID(s) {0}',
  Q_BR_001: 'Duplicate question found with label {0}',
  CDS_GET_FAILED: 'Common Data Service Failed to fetch data from the database',
  CDS_FIND_BY_ID_FAILED: 'Common Data Service Failed to find data by ID',
  CDS_SAVE_FAILED: 'Common Data Service Failed to save data',
  CDS_FINDBYDATA_FAILED: 'Common Data Service Failed to find data by criteria',
  Q_FIND_BY_ID_FAILED: 'Failed to find question by ID {0}',
  Q_FIND_BY_LABEL_TYPE_FAILED: 'Failed to find question by label {0} and type {1}',
  Q_SAVE_FAILED: 'Failed to save question with label {0}',
  Q_DELETE_FAILED: 'Failed to delete question with ID {0}',
  Q_COUNT_FAILED: 'Failed to count questions with criteria {0}',
  Q_BY_PROGRAM_ID_FAILED: 'Failed to fetch questions by program ID {0}',
  // Option Category Messages
  OC_NF_001: 'Option category not found with ID {0}',
  OC_NF_002: 'Updator not found for option category with ID {0}',
  OC_BR_001: 'Duplicate option category found with name {0}',
  OC_FIND_BY_ID_FAILED: 'Failed to find option category by ID {0}',
  OC_SAVE_FAILED: 'Failed to save option category with name {0}',
  OC_DELETE_FAILED: 'Failed to delete option category with ID {0}',
  OC_COUNT_FAILED: 'Failed to count option categories with criteria {0}',
  OC_GET_FAILED: 'Failed to fetch option categories from the database',

  // User Messages
  U_NF_001: 'User not found with ID: {0}',
  U_NF_002: 'User not found with combined phone number {0}',
  U_BR_001: 'Email already exists for another user',
  U_BR_002: 'Phone number cannot be updated',
  U_BR_003: 'Phone number already exists for another user',
  U_BR_004: 'Email does not match user details',
  U_BR_005: 'Phone number does not match user details',

  // Option Messages
  O_NF_001: 'Option creator not found with ID {0}',
  O_NF_002: 'Option updator not found with ID {0}',
  O_NF_003: 'Option not found with ID {0}',
  O_BR_001: 'Duplicate option found with name {0}',
  O_FIND_BY_ID_FAILED: 'Failed to find option by ID {0}',
  O_FIND_BY_LABEL_TYPE_FAILED: 'Failed to find option by label {0} and type {1}',
  O_SAVE_FAILED: 'Failed to save option with name {0}',
  O_DELETE_FAILED: 'Failed to delete option with ID {0}',
  O_COUNT_FAILED: 'Failed to count options with criteria {0}',
  O_GET_FAILED: 'Failed to fetch options from the database',
  // Question-Option Mapping Messages
  QO_NF_001: 'Question-option mapping not found with ID {0}',
  QO_NF_002: 'Creator not found for question-option mapping with ID {0}',
  QO_NF_003: 'Updator not found for question-option mapping with ID {0}',
  QO_BR_001: 'Duplicate question-option mapping found for question ID {0} and option ID {1}',
  QO_FIND_BY_ID_FAILED: 'Failed to find question-option mapping by ID {0}',
  QO_FIND_ALL_FAILED: 'Failed to fetch question-option mappings from the database',
  QO_SAVE_FAILED: 'Failed to save question-option mapping for question ID  and option ID ',
  QO_UPDATE_FAILED: 'Failed to update question-option mapping with ID {0}',
  QO_DELETE_FAILED: 'Failed to delete question-option mapping with ID {0}',
  QO_GET_FAILED: 'Failed to fetch question-option mappings with criteria {0}',
  QO_CREATION_FAILED: 'Failed to create question-option mappings for question ID {0}',
  // Program Messages
  P_NF_001: 'Program creator not found with ID {0}',
  P_NF_002: 'Program updator not found with ID {0}',
  P_NF_003: 'Program not found with ID {0}',
  PROGRAM_DUPLICATE_BADREQUEST: 'Duplicate program found with name {0}',
  PROGRAM_FIND_BY_ID_FAILED: 'Failed to find program by ID {0}',
  PROGRAM_SAVE_FAILED: 'Failed to save program with name {0}',
  PROGRAM_DELETE_FAILED: 'Failed to delete program with ID {0}',
  PROGRAM_GET_FAILED: 'Failed to fetch programs from the database',
  PROGRAM_COUNT_FAILED: 'Failed to count programs with criteria {0}',
  PROGRAM_FEE_NOTFOUND: 'Program fee not found',
  REGISTRATION_CANT_BE_UPDATED: 'Registration cannot be updated in its current status',
  PROGRAM_NOT_ALLOCATED: 'Program not allocated to this registration with ID {0}',
  // Program Type Messages
  PT_NF_001: 'Program type not found with ID {0}',
  PT_COUNT_FAILED: 'Failed to count program types with criteria {0}',
  PT_SAVE_FAILED: 'Failed to save program type with name {0}',
  PROGRAM_TYPE_DELETE_FAILED: 'Failed to delete program type with ID {0}',
  PT_GET_FAILED: 'Failed to fetch program types from the database',
  PROGRAM_TYPE_FIND_BY_NAME_FAILED: 'Failed to find program type by name {0}',
  PROGRAM_TYPE_SAVE_FAILED: 'Failed to save program type with name {0}',
  PROGRAM_TYPE_COUNT_FAILED: 'Failed to count program types with criteria {0}',
  PROGRAM_TYPE_CREATOR_NOTFOUND: 'Program type creator not found with ID {0}',
  PROGRAM_TYPE_UPDATOR_NOTFOUND: 'Program type updator not found with ID {0}',
  PROGRAM_SWAP_REQUEST_GET_FAILED: 'Failed to fetch program swap requests',
  SWAP_REQUEST_ALREADY_UPDATED: 'Swap request with ID {0} has already been updated',
  PROGRAM_NOT_FOUND: 'Program not found with ID {0}',
  SEATS_ALREADY_FULL: 'Seats are already full for the program with ID {0}',
  NO_FILLED_SEATS: 'No filled seats found for the program with ID {0}',
  PROGRAM_REGISTRATION_NOT_FOUND: 'Program registration not found with ID {0}',
  TARGET_PROGRAM_NOT_FOUND: 'Target program not found with ID {0}',
  SWAP_REQUEST_ALREADY_EXISTS: 'Swap request already exists for program registration ID {0}',
  INVALID_SWAP_REQUEST_STATUS: 'Invalid swap request status {0} for program registration ID {1}',
  PT_BR_001: 'Duplicate program type found with name {0}',

  // Form Section Messages
  FS_NF_001: 'Form section creator not found with ID {0}',
  FS_NF_002: 'Form section updator not found with ID {0}',
  FS_NF_003: 'Form section not found with ID {0}',
  FS_BR_001: 'Duplicate form section found with name {0}',
  FS_FIND_FAILED: 'Failed to find form sections',

  // Program Question Messages
  PQ_NF_001: 'Program-question mapping not found with ID {0}',
  PQ_NF_002: 'Creator not found for program-question mapping with ID {0}',
  PQ_NF_003: 'Updator not found for program-question mapping with ID {0}',
  PQ_BR_001: 'Duplicate program-question mapping found for program ID {0} and question ID {1}',
  PQ_BR_002: 'program session level required for program-question mapping {0}',
  PQ_BR_003: 'program session level not found for program-question mapping {0}',
  PQ_FIND_BY_ID_FAILED: 'Failed to find program-question mapping by ID {0}',
  PQ_FIND_ALL_FAILED: 'Failed to fetch program-question mappings from the database',
  PQ_SAVE_FAILED: 'Failed to save program-question mapping for program ID {0} and question ID {1}',
  PQ_UPDATE_FAILED: 'Failed to update program-question mapping with ID {0}',
  PQ_DELETE_FAILED: 'Failed to delete program-question mapping with ID {0}',
  PQ_GET_FAILED: 'Failed to fetch program-question mappings with criteria {0}',
  PQ_CREATION_FAILED: 'Failed to create program-question mappings for program ID {0}',
  PQ_BULK_UPDATE_FAILED: 'Failed to bulk update program-question mappings for program ID {0}',
  PQ_BULK_DELETE_FAILED: 'Failed to bulk delete program-question mappings for program ID {0}',
  PQ_GET_BY_PROGRAM_ID_FAILED: 'Failed to fetch program-question mappings by program ID {0}',
  PQ_GET_BY_PROGRAM_SESSION_ID_FAILED:
    'Failed to fetch program-question mappings by program session ID {0}',

  // Form Schema Service Messages
  FORM_SCHEMA_001: 'Failed to generate form schema from metadata: {0}',
  FORM_SCHEMA_002: 'Failed to process form schema: {0}',
  FORM_SCHEMA_003: 'Failed to create new question: {0}',
  FORM_SCHEMA_004: 'Program metadata is required',
  FORM_SCHEMA_005: 'Program ID is required in the metadata',
  FORM_SCHEMA_006: 'Program with ID {0} not found',

  // Program Session Messages
  PS_NF_001: 'Program session creator not found with ID {0}',
  PS_NF_002: 'Program session updator not found with ID {0}',
  PS_NF_003: 'Program session not found with ID {0}',
  PS_BR_001: 'Duplicate program session found with name/number/code {0}',
  PS_FIND_BY_ID_FAILED: 'Failed to find program session by ID {0}',
  PS_SAVE_FAILED: 'Failed to save program session with name {0}',
  PS_DELETE_FAILED: 'Failed to delete program session with ID {0}',
  PS_GET_FAILED: 'Failed to fetch program sessions from the database',
  PS_COUNT_FAILED: 'Failed to count program sessions with criteria {0}',
  PR_INVALID_SESSION: 'Invalid program session for program ID {0} and session ID {1}',
  PROGRAM_DASHBOARD_DATA_GET_FAILED: 'Failed to fetch program dashboard data for program ID {0}',
  // Registration
  R_BR_001: 'Question {0} is not valid for this program/session',
  R_BR_002: 'Registration cannot be updated in its current status',
  R_BR_004: 'Registration already approved',
  R_SAVE_FAILED: 'Failed to create registration',
  R_NO_SPACE: 'No seats available for registration',
  RF_SAVE_FAILED: 'Failed to record registration failure',
  USER_ALREADY_REGISTERED: 'Already registered for this program/session {0}',
  REGISTRATION_ALREADY_EXISTS: 'User already registered for this program {0}',
  USER_NOT_FOUND_BY_ROLE: 'User not found with role {0} and ID {1}',
  // MISSING ERROR CODES ADDED BELOW

  // COMMON_DATA_SERVICE
  CDS_UPDATE_FAILED: 'Common Data Service failed to update data',

  // Program Registration
  PR_NF_001: 'Program registration not found with ID {0}',
  PROGRAM_REGISTRATION_NOTFOUND: 'Program registration not found with ID {0}',
  PR_SAVE_FAILED: 'Failed to save program registration',
  PR_DELETE_FAILED: 'Failed to delete program registration',
  PR_GET_FAILED: 'Failed to fetch program registrations',
  PR_FIND_BY_ID_FAILED: 'Failed to find program registration by ID {0}',

  // Registration Approval
  RA_NF_001: 'Registration approval not found with ID {0}',
  RA_SAVE_FAILED: 'Failed to save registration approval',
  RA_DELETE_FAILED: 'Failed to delete registration approval',
  RA_GET_FAILED: 'Failed to fetch registration approvals',
  RA_FIND_BY_ID_FAILED: 'Failed to find registration approval by ID {0}',
  RA_ALREADY_EXISTS: 'Registration approval already exists for registration ID {0}',
  RA_TRACK_GET_FAILED: 'Failed to fetch registration approval track records',
  RA_NEEDED: 'Registration needs approval for registration ID {0}',

  // Registration Custom Response
  RCR_NF_001: 'Registration custom response not found with ID {0}',
  RCR_SAVE_FAILED: 'Failed to save registration custom response',
  RCR_DELETE_FAILED: 'Failed to delete registration custom response',
  RCR_GET_FAILED: 'Failed to fetch registration custom responses',
  RCR_FIND_BY_ID_FAILED: 'Failed to find registration custom response by ID {0}',

  // Registration Invoice Detail
  RID_NF_001: 'Registration invoice detail not found with ID {0}',
  RID_SAVE_FAILED: 'Failed to save registration invoice detail',
  RID_DELETE_FAILED: 'Failed to delete registration invoice detail',
  RID_GET_FAILED: 'Failed to fetch registration invoice details',
  RID_FIND_BY_ID_FAILED: 'Failed to find registration invoice detail by ID {0}',
  RID_UPDATE_FAILED: 'Failed to update registration invoice detail with ID {0}',

  // Registration Payment Detail
  RPD_NF_001: 'Registration payment detail not found with ID {0}',
  RPD_SAVE_FAILED: 'Failed to save registration payment detail',
  RPD_DELETE_FAILED: 'Failed to delete registration payment detail',
  RPD_GET_FAILED: 'Failed to fetch registration payment details',
  RPD_FIND_BY_ID_FAILED: 'Failed to find registration payment detail by ID {0}',

  // Registration Travel Info
  RTI_NF_001: 'Registration travel info not found with ID {0}',
  RTI_SAVE_FAILED: 'Failed to save registration travel info',
  RTI_DELETE_FAILED: 'Failed to delete registration travel info',
  RTI_GET_FAILED: 'Failed to fetch registration travel info',
  RTI_FIND_BY_ID_FAILED: 'Failed to find registration travel info by ID {0}',

  // Registration Travel Plan
  RTP_NF_001: 'Registration travel plan not found with ID {0}',
  RTP_SAVE_FAILED: 'Failed to save registration travel plan',
  RTP_DELETE_FAILED: 'Failed to delete registration travel plan',
  RTP_GET_FAILED: 'Failed to fetch registration travel plans',
  RTP_FIND_BY_ID_FAILED: 'Failed to find registration travel plan by ID {0}',

  // Registration
  RE_NF_001: 'Registration not found with ID {0}',
  RE_ID_REQUIRED: 'Registration ID is required',
  REGISTRATION_NOTFOUND: 'Registration not found with ID {0}',
  RE_ALREADY_CANCELLED: 'Registration with ID {0} is already cancelled',
  REGISTRATION_SAVE_FAILED: 'Failed to save registration',
  REGISTRATION_GET_FAILED: 'Failed to fetch registrations',
  REGISTRATION_FIND_BY_ID_FAILED: 'Failed to find registration by ID {0}',
  RE_CANCEL_NOT_ALLOWED: 'Registration cannot be cancelled after program start',
  RE_CANCEL_UNAUTHORIZED: 'User not authorized to cancel registration',
  REGISTRATION_INVALID_QUESTION: 'Invalid question for registration: {0}',
  REGISTRATION_CREATION_FAILED: 'Failed to create registration',
  REGISTRATION_NO_SPACE: 'No space available for registration',
  REGISTRATION_FAILURE_SAVE_FAILED: 'Failed to save registration failure',
  R_BR_003: 'Registration of id {0} is pending approval',
  REGISTRATION_QUESTION_RESPONSE_GET_FAILED: 'Failed to fetch registration question responses',

  // User
  USER_GET_ALL_FAILED: 'Failed to fetch users',

  PAYMENT_ALREADY_EXISTS: 'Payment already exists for registration ID {0}',
  PAYMENT_INITIATION_FAILED: 'Failed to initiate payment for registration ID {0}',
  PAYMENT_UPDATE_FAILED: 'Failed to update payment for registration ID {0}',
  PAYMENT_NOTFOUND: 'Payment not found with ID {0}',
  PAYMENT_GET_FAILED: 'Failed to fetch payment details',
  PAYMENT_CREATION_FAILED: 'Failed to create payment',
  PAYMENT_CONFIRMATION_FAILED: 'Failed to confirm payment',
  TDS_AMOUNT_INVALID: 'TDS amount is invalid',
  TDS_AMOUNT_EXCEEDS: 'TDS amount exceeds the total payment amount',
  PAYMENT_ALREADY_COMPLETED: 'Payment already completed for registration ID : {0}, status : {1}',
  PAYMENT_EDIT_STATUS_ALREADY_SET:
    'Payment edit status is already set for registration ID : {0}, status : {1}',
  PAYMENT_INCOMPLETE: 'Payment is not completed',

  INVALID_WEBHOOK_SIGNATURE: 'Invalid webhook signature',
  WEBHOOK_PROCESSING_FAILED: 'Failed to process webhook data',
  INVALID_WEBHOOK_DATA: 'Invalid webhook data received',

  EINVOICE_GENERATION_FAILED: 'Failed to generate e-invoice',
  RAZORPAY_ORDER_CREATION_FAILED: 'Failed to create Razorpay order',
  FAILED_TO_GENERATE_PROFORMA_INVOICE_SEQ_NUMBER:
    'Failed to generate proforma invoice sequence number',
  INVOICE_CODE_NOT_FOUND: 'Invoice code not found',
  INVOICE_SEQUENCE_START_NOT_FOUND: 'Invoice sequence start not found',
  PRO_FORMA_INVOICE_SEQUENCE_START_NOT_FOUND: 'Pro forma invoice sequence start not found',
  INVOICE_SEQUENCE_NUMBER_NOT_FOUND: 'Invoice sequence number not found',
  INVOICE_SEQUENCE_GENERATION_FAILED: 'Failed to generate invoice sequence number',
  RAZORPAY_PAYMENT_CAPTURE_FAILED: "Failed to capture Razorpay payment",

  // General
  INTERNAL_SERVER_ERROR: 'Internal server error',

  // Question
  Q_ID_REQUIRED: 'Question ID is required',

  // Program Question
  PQ_ID_REQUIRED: 'Program-question mapping ID is required',
  PQ_SECTION_DELETE_FAILED: 'Failed to delete section and its questions',
  PQ_EXISTING_MAPPING_CHECK_FAILED: 'Failed to check for existing program-question mappings',
  PQ_SCOPE_VALIDATION_FAILED: 'Scope validation failed for program-question mapping',
  PQ_CUSTOM_QUESTION_CREATION_FAILED:
    'Failed to create custom question for program-question mapping',
  PQ_OPTION_MAPPING_FAILED: 'Failed to map options for program-question mapping',
  PQ_TRANSACTION_FAILED: 'Transaction failed for program-question mapping',
  PQ_VALIDATION_FAILED: 'Validation failed for program-question mapping',

  // Form Section
  FS_ID_REQUIRED: 'Form section ID is required',
  FS_EXISTING_MAPPING_CHECK_FAILED: 'Failed to check for existing form-section mappings',
  FS_SCOPE_VALIDATION_FAILED: 'Scope validation failed for form-section',
  FS_CUSTOM_QUESTION_CREATION_FAILED: 'Failed to create custom question for form-section',
  FS_OPTION_MAPPING_FAILED: 'Failed to map options for form-section',

  // Registration
  REG_ID_REQUIRED: 'Registration ID is required',
  INVALID_PARENT_FILTER: 'Invalid parent filter',
  INVALID_REPORT_CODE: 'Invalid report code',
  ACCESS_DENIED_TO_REPORT: 'Access denied to this report',
  NO_DATA_FOUND_FOR_REPORT: 'No data found for the requested report with current filters',

  PREF_SAVE_FAILED: 'Failed to save preferences',
  PREF_DELETE_FAILED: 'Failed to delete preferences',
  PREF_GET_FAILED: 'Failed to fetch preferences',

  PREF_NF_001: 'Preference not found with ID {0}',
  PREF_NF_002: 'Preference creator not found with ID {0}',
  PREF_NF_003: 'Preference updator not found with ID {0}',
  PREF_BR_001: 'Duplicate preference found with registration ID {0} and program ID {1}',
  PREF_FIND_BY_ID_FAILED: 'Failed to find preference by ID {0}',
  PREF_FIND_BY_REGISTRATION_ID_FAILED: 'Failed to find preferences by registration ID {0}',
  PREF_PRIORITY_ORDER_NOT_UNIQUE:
    'Priority order is not unique for preferences with registration ID {0} and program ID {1}',
  PREF_ALREADY_EXISTS: 'Preferences already exist for registration ID {0} and program ID {1}',
  PREFERENCE_SAVE_FAILED: 'Failed to save preferences',
  PREFERENCE_DELETE_FAILED: 'Failed to delete preferences',
  PREFERENCE_GET_FAILED: 'Failed to fetch preferences',
  PREFERENCE_NOTFOUND: 'Preference not found with ID {0}',
  PREFERENCE_CREATOR_NOTFOUND: 'Preference creator not found with ID {0}',
  PREFERENCE_UPDATOR_NOTFOUND: 'Preference updator not found with ID {0}',
  PREFERENCE_DUPLICATE_BADREQUEST:
    'Duplicate preference found with registration ID {0} and program ID {1}',
  PREFERENCE_FIND_BY_ID_FAILED: 'Failed to find preference by ID {0}',
  PREFERENCE_FIND_BY_REGISTRATION_ID_FAILED: 'Failed to find preferences by registration ID {0}',
  PREFERENCE_PRIORITY_ORDER_NOT_UNIQUE:
    'Priority order is not unique for preferences with registration ID {0} and program ID {1}',
  PREFERENCE_ALREADY_EXISTS: 'Preferences already exist for registration ID {0} and program ID {1}',

  // Commonication
  FAILED_TO_SEND_EMAIL: 'Failed to send email',
  FAILED_TO_SEND_BULK_EMAIL: 'Failed to send bulk emails',
  FAILED_TO_HANDLE_EMAIL_WEBHOOK: 'Failed to handle email webhook',
  FAILED_TO_SEND_WHATSAPP_MESSAGE: 'Failed to send WhatsApp message',
  FAILED_TO_SEND_BULK_WHATSAPP_MESSAGE: 'Failed to send bulk WhatsApp messages',
  FAILED_TO_HANDLE_WHATSAPP_WEBHOOK: 'Failed to handle WhatsApp webhook',

  // Communication Track
  COMMUNICATION_TRACK_NOTFOUND: 'Communication track not found with ID {0}',
  COMMUNICATION_TRACK_GET_FAILED: 'Failed to fetch communication tracks',
  COMMUNICATION_TRACK_FIND_BY_ID_FAILED: 'Failed to find communication track by ID {0}',
  COMMUNICATION_TRACK_SAVE_FAILED: 'Failed to save communication track',
  COMMUNICATION_TRACK_DELETE_FAILED: 'Failed to delete communication track with ID {0}',
  COMMUNICATION_TRACK_UPDATE_FAILED: 'Failed to update communication track with ID {0}',

  REGISTRATION_NOT_STARTED: 'Registration not started for this program/session',
  REGISTRATION_ALREADY_STARTED: 'Registration already started for this program/session',
  REGISTRATION_CLOSED: 'Registration closed for this program/session',

  PROGRAM_REGISTRATION_RM_RATING_SAVE_FAILED:
    'Failed to save RM rating for program registration with ID {0}',
  PROGRAM_REGISTRATION_RM_RATING_FAILED:
    'Failed to fetch RM ratings for program registration with ID {0}',
  PROGRAM_REGISTRATION_RM_RATING_NOT_FOUND:
    'RM ratings not found for program registration with ID {0}',
  PROGRAM_REGISTRATION_RM_RATING_UPDATE_FAILED:
    'Failed to update RM rating for program registration with ID {0}',
  PROGRAM_SWAP_REQUEST_UPDATE_FAILED: 'Failed to update program swap request with ID {0}',
  PROGRAM_SWAP_REQUEST_NOT_FOUND: 'Program swap request not found with ID {0}',

  DUPLICATE_DISPLAY_ORDER: 'Duplicate display order found for program',
  INVALID_CHILD_DISPLAY_ORDER: 'Invalid display order for child program',
  INVALID_PRIMARY_DISPLAY_ORDER: 'Invalid display order for primary program',
  CANNOT_CHANGE_TO_NON_GROUPED_TYPE:
    'Cannot change program type to non-grouped type when it has child programs',
  GROUP_ID_MISMATCH: 'Group ID mismatch for program with ID {0}',
  PRIMARY_PROGRAM_NOT_FOUND: 'Primary program not found with ID {0}',
  INVALID_GROUP_CONFIGURATION: 'Invalid group configuration for program with ID {0}',
  INVALID_ADDRESS_TYPE: 'Invalid address type provided for program',
  INVALID_PINCODE: 'Invalid pincode provided for program',
  PROGRAM_TYPE_DOES_NOT_SUPPORT_GROUPING: 'Program type does not support grouping',
  CANNOT_UPDATE_GROUPED_PROGRAMS_ON_NON_PRIMARY:
    'Cannot update grouped programs on non-primary program',
  DUPLICATE_GROUP_DISPLAY_ORDER: 'Duplicate display order found for grouped programs',
  INVALID_GROUP_DISPLAY_ORDER: 'Invalid display order for grouped programs',
  DUPLICATE_PROGRAM_CODES_IN_GROUP: 'Duplicate program codes found in grouped programs',
  INVALID_DATE_RANGE: 'Invalid date range provided for program',
  INVALID_REGISTRATION_DATE_RANGE: 'Invalid registration date range provided for program',
  INVALID_SEAT_CONFIGURATION: 'Invalid seat configuration provided for program',
  INVALID_TIME_RANGE: 'Invalid time range provided for program',
  INVALID_CHECKIN_CHECKOUT_DATE_RANGE: 'Invalid check-in/check-out date range provided for program',
  MESSAGE_SAVE_FAILED: 'Failed to save message',
  MESSAGE_GET_FAILED: 'Failed to retrieve messages',
  MESSAGE_INVALID_SENDER: 'Only team members can send messages',
  MESSAGE_INVALID_RECEIVER: 'Receiver must be a team member',
  INVALID_SEAT_COUNT: 'Invalid seat count provided for program',
  INVALID_PROGRAM_HIERARCHY: 'Invalid program hierarchy configuration',
  DUPLICATE_IDS_IN_REQUEST: 'Duplicate IDs found in the request',
  INVALID_PROGRAM_IDS: 'Invalid program IDs provided in the request',
  INVALID_DELETION_REQUEST: 'Invalid deletion request for program',
  DUPLICATE_IDS_IN_DELETION_REQUEST: 'Duplicate IDs found in the deletion request',
  INVALID_DELETED_PROGRAM_IDS: 'Invalid deleted program IDs provided in the request',
  CANNOT_DELETE_PRIMARY_PROGRAM: 'Cannot delete primary program',
  CONFLICTING_PROGRAM_IDS: 'Conflicting program IDs found in the request',

  FAILED_TO_ANALYZE: 'Failed to analyze the document',
  FAILED_TO_VERIFY_FLIGHT_TICKET: 'Failed to verify if the document is a flight ticket',
  FAILED_TO_EXTRACT_FLIGHT_DATA: 'Failed to extract flight data from the document',
  PASSENGER_NAME_MISMATCH:
    'The uploaded flight ticket does not belong to the specified user. Please upload a ticket with your name.',
  NO_PASSENGER_NAMES_FOUND:
    'No passenger names found in the ticket. Please upload a valid flight ticket with passenger information.',
  FLIGHT_DESTINATION_MISMATCH:
    'Flight destination does not match program venue. Please upload a ticket with the correct destination.',
  FLIGHT_ORIGIN_MISMATCH:
    'Flight origin does not match program venue. Please upload a ticket with the correct origin.',

  // File Upload
  FAILED_TO_GENERATE_FILE_URLS: 'Failed to generate file upload URLs',
  FILE_UPLOAD_FAILED: 'File upload failed, please try again later',
  FAILED_TO_GENERATE_UPLOAD_URLS: 'Failed to generate upload URLs for the file',

  RTP_UPDATE_FAILED: 'Failed to update registration travel plan with ID {0}',
  RTP_CREATE_FAILED: 'Failed to create registration travel plan for registration ID {0}',
  RTI_UPDATE_FAILED: 'Failed to update registration travel info with ID {0}',
  RTI_CREATE_FAILED: 'Failed to create registration travel info for registration ID {0}',
  REG_STATUS_UPDATE_FAILED: 'Failed to update registration status for registration ID {0}',

  US_SAVE_FAILED: 'Failed to save user session',
  US_UPDATE_FAILED: 'Failed to update user session with ID {0}',
  US_NF_001: 'User session not found',
  US_ATTEMPTS: 'Maximum OTP attempts exceeded',
  US_EXPIRED: 'OTP expired',
  US_INVALID_OTP: 'Invalid OTP supplied',
  U_SAVE_FAILED: 'Failed to save user information',
  AUTH_INVALID_LOGIN_TYPE: 'Invalid login type provided. Supported types are PHONE and EMAIL.',
  U_UPDATE_FAILED: 'Failed to update user information with ID {0}',
  U_CREATION_FAILED: 'Failed to create user with phone number {0} and country code {1}',

  PAYMENT_NOT_ALLOWED_FOR_FREE_SEAT:
    'Payment is not allowed for free seats in program registration with ID {0}',

  // Program Registration Recommendations
  PR_RECOMMENDATION_SAVE_FAILED: 'Failed to save program registration recommendation',
  PR_RECOMMENDATION_NOT_FOUND: 'Program registration recommendation not found with ID {0}',
  PR_RECOMMENDATION_UPDATE_FAILED:
    'Failed to update program registration recommendation with ID {0}',
  PR_RECOMMENDATION_GET_FAILED: 'Failed to fetch program registration recommendations',
  INVALID_ALLOCATED_PROGRAM_SESSION:
    'Invalid allocated program session for program registration {0}',

  PROGRAM_VENUE_CITY_REQUIRED:
    'Program venue city information is required for flight validation but not found',
  INVALID_ONGOING_LOCATION:
    'Invalid flight ticket. {0} flight destination {1} should be same as the Program Location {2}',
  INVALID_RETURN_LOCATION:
    'Invalid flight ticket. {0} flight departure {1} should be same as the Program Location {2}',
  UNABLE_TO_EXTRACT_TEXT:
    'Unable to extract readable text from the document. Please ensure the image is clear and contains a valid flight ticket.',
  FILE_NOT_FLIGHT_TICKET: 'The uploaded file is not a Flight ticket',
  PDF_FILE_CORRUPTED:
    'PDF file appears to be corrupted or invalid. Please re-upload a valid PDF file.',
  UNSUPPORTED_FILE_FORMAT: 'Unsupported file format. Please upload JPG, PNG, or PDF files only.',
  FILE_CORRUPTED: '{0} file appears to be corrupted or invalid. Please re-upload a valid file.',
  FILE_UNREADABLE: 'File is unreadable or empty. Please re-upload with a valid document.',
  INVALID_FLIGHT_DATE_ONWARD:
    'Invalid onward flight time. Flight must arrive before program start time (or any time the day before).',
  INVALID_FLIGHT_DATE_RETURN:
    'Invalid return flight time. Flight must depart after program end time (or any time the day after).',
  PROGRAM_DATES_REQUIRED: 'Program start and end dates are required for flight date validation.',
  PARTIAL_DATA:
    'All the data cannot be extracted from the ticket. Please upload a valid ticket with clear and complete information.',
  TICKET_UNREADABLE: 'Ticket unreadable. Please re-upload with valid format',
  AIRLINE_NUMBER_EXTRACTION_FAILED:
    'Airline number data cannot be extracted from the ticket. Please upload a valid ticket with clear and complete information.',
  FLIGHT_NUMBER_EXTRACTION_FAILED:
    'Flight number data cannot be extracted from the ticket. Please upload a valid ticket with clear and complete information.',
  ORIGIN_LOCATION_MISSING:
    'Origin location data is missing from the ticket. Please upload a valid ticket with clear and complete information.',
  DESTINATION_LOCATION_MISSING:
    'Destination location data is missing from the ticket. Please upload a valid ticket with clear and complete information.',
  DEPARTURE_ARRIVAL_TIME_MISSING:
    'Departure or arrival time data is missing from the ticket. Please upload a valid ticket with clear and complete information.',
  ROUND_TRIP_SEGMENTS_MISSING: 'Round-trip flight must have both onward and return segments',
  RETURN_FLIGHT_DETAILS_MISSING:
    'Onward flight details are valid. Return flight dates do not match program schedule.',
  ONWARD_FLIGHT_DETAILS_MISSING:
    'Return flight details are valid. Onward flight dates do not match program schedule.',
  ONWARD_RETURN_FLIGHT_MISMATCH:
    'Onward and return journey times should match with program schedule. Onward flight must arrive before program start time, and return flight must depart after program end time.',

  // Identity Document Related Error Messages
  INVALID_IDENTITY_DOCUMENT:
    'The uploaded document is not a valid identity document. Please upload a valid government-issued identity document.',
  FAILED_TO_EXTRACT_IDENTITY_DATA:
    'Failed to extract identity information from the document. Please ensure the document is clear and readable.',
  IDENTITY_DOCUMENT_NAME_MISMATCH:
    'The uploaded identity document does not belong to the specified user. Please upload a document with your name.',
  IDENTITY_DOCUMENT_TYPE_REQUIRED:
    'Document type is required for identity document processing. Please select the type of identity document (Aadhar, Driving license, Passport, Pan card, or Voter id).',
  IDENTITY_DOCUMENT_TYPE_MISMATCH:
    'Uploaded document does not match with the selected type. Please upload a valid document of selected type.',

  // Registration Payment Details History
  PAYMENT_HISTORY_NOT_FOUND: 'Payment history not found with ID {0}',
  PAYMENT_HISTORY_UPDATE_FAILED: 'Failed to update payment history with ID {0}',
  PAYMENT_HISTORY_SAVE_FAILED:
    'Failed to save payment history for registration ID {0} and payment mode {1}',

  // Communication Templates
  COMMUNICATION_TEMPLATE_NOTFOUND: 'Communication template not found with ID {0}',
  COMMUNICATION_TEMPLATE_GET_FAILED: 'Failed to fetch communication templates',
  COMMUNICATION_TEMPLATE_FIND_BY_ID_FAILED: 'Failed to find communication template by ID {0}',
  COMMUNICATION_TEMPLATE_FIND_BY_KEY_FAILED: 'Failed to find communication template by key {0}',
  COMMUNICATION_TEMPLATE_SAVE_FAILED: 'Failed to save communication template with key {0}',
  FAILED_TO_FETCH_TEMPLATE: 'Failed to fetch communication template with key {0}',
  COMMUNICATION_TEMPLATE_FIND_BY_KEY_AND_TYPE_FAILED:
    'Failed to find communication template by key {0} and type {1}',
  FAILED_TO_SEND_PREPARATORY_COMMUNICATION: 'Failed to send preparatory communication',
  FAILED_TO_SEND_FIRST_TIMER_COMMUNICATION: 'Failed to send first timer communication',
  FAILED_TO_SEND_CHECKLIST_COMMUNICATION: 'Failed to send checklist communication',
  COMMUNICATION_SEND_FAILED: 'Failed to send communication',
  REGISTRATIONS_NOT_FOUND_TO_SEND_COMMUNICATION:
    'No registrations found to send communication for program ID {0} and session ID {1}',
  REGISTRATION_TRAVEL_PLAN_COMMUNICATION_FAILED:
    'Failed to send travel plan communication for registration ID {0}',

  // Payment Edit Request Errors
  PAYMENT_EDIT_REQUEST_NOT_FOUND: 'Payment edit request not found',
  PAYMENT_EDIT_REQUEST_ALREADY_EXISTS: 'Payment edit request already exists',
  PAYMENT_EDIT_REQUEST_PROCESSING_FAILED: 'Payment edit request processing failed',

  // User Participation Messages
  UP_NF_001: 'No participation records found for user ID: {0}',
  UP_NF_002: 'No participation records found for user ID: {0} in year: {1}',
  UP_GET_FAILED: 'Failed to fetch user participation data for user ID: {0}',
  UP_STATS_FAILED: 'Failed to fetch user participation statistics for user ID: {0}',
  UP_YEAR_COUNT_FAILED: 'Failed to fetch year-wise participation count for user ID: {0}',
  UP_UNIQUE_PROGRAMS_FAILED: 'Failed to fetch unique program names for user ID: {0}',

  // User Program Experience
  UPE_INVALID_LOOKUP: 'One or more lookup IDs are invalid for seeker program experiences: {0}',
  UPE_SAVE_FAILED: 'Failed to save user program experiences',
  UPE_UPDATE_FAILED: 'Failed to update user program experiences',
  UPE_GET_FAILED: 'Failed to fetch user program experiences',
  UPE_DELETE_FAILED: 'Failed to delete user program experiences',
  UPE_LOOKUP_FAILED: 'Failed to fetch lookup data for seeker program experiences',
  UPE_REGISTRATION_MISMATCH: 'Registration {0} does not belong to user {1}',
  URM_SAVE_FAILED: 'Failed to save user registration mappings',
  URM_UPDATE_FAILED: 'Failed to update user registration mappings',
  URM_DELETE_FAILED: 'Failed to delete user registration mappings',
  URM_GET_FAILED: 'Failed to fetch user registration mappings',
  URM_NOT_FOUND: 'User registration mapping not found for registration ID {0}',
  URM_REG_NOT_COMPLETED: 'Registration {0} is not completed',
  URM_REG_MISMATCH: 'Registration {0} does not belong to user {1}',
  URM_USER_MISMATCH: 'User ID in request body {0} does not match path parameter {1}',
  URM_SUMMARY_FAILED: 'Failed to create or update user participation summary',
  URM_RESTORE_FAILED: 'Failed to restore user registration mapping for registration ID {0}',

  // Registration Clear Operations
  REGISTRATION_CLEAR_NOT_ALLOWED: 'Registration clear operation is not allowed for env {0}',
  REGISTRATION_CLEAR_NOT_ENABLED: 'Registration clear operation is not enabled for env {0}',
  REGISTRATION_CLEAR_FAILED: 'Failed to clear registrations for program',

  // Room Allocation
  ROA_NF_001: 'Room allocation not found with ID {0}',
  ROA_NF_002: 'Room allocation creator not found with ID {0}',
  ROA_NF_003: 'Room allocation updator not found with ID {0}',
  ROA_BR_001: 'Room allocation already exists for registration ID {0}',
  ROA_BR_002: 'Invalid bed position {0} for room allocation',
  ROA_BR_003: 'Room capacity exceeded for room allocation',
  ROA_BR_004: 'Program mismatch for room allocation with registration ID {0}',
  ROA_BR_005: 'Bed position {0} is already occupied in room {1}',
  ROA_BR_006: 'Bed position {0} is out of range for room capacity {1}',
  ROA_BR_007: 'Insufficient room capacity. Requested: {0}, Available: {1}',
  ROA_BR_008: 'Duplicate registration IDs found in the request: {0}',
  ROA_BR_009: 'Duplicate bed positions found in the request: {0}',
  ROA_BR_010: 'Duplicate allocation IDs found in the array',
  ROA_BR_011: 'Allocation IDs {0} do not belong to room inventory {1}',
  ROA_CREATE_FAILED: 'Failed to create room allocation',
  ROA_UPDATE_FAILED: 'Failed to update room allocation with ID {0}',
  ROA_DELETE_FAILED: 'Failed to delete room allocation with ID {0}',
  ROA_GET_FAILED: 'Failed to fetch room allocations',
  ROA_FIND_FAILED: 'Failed to find room allocation with criteria {0}',
  ROA_COUNT_FAILED: 'Failed to count room allocations with criteria {0}',
  ROA_FIND_BY_ID_FAILED: 'Failed to find room allocation by ID {0}',
  ROA_FIND_BY_REGISTRATION_ID_FAILED: 'Failed to find room allocation by registration ID {0}',
  ROA_FIND_BY_ROOM_INVENTORY_FAILED: 'Failed to find room allocations by room inventory ID {0}',
  ROA_VALIDATION_FAILED: 'Room allocation validation failed',
  ROA_TRANSACTION_FAILED: 'Room allocation transaction failed',
  ROA_BULK_CREATE_FAILED: 'Failed to create bulk room allocations',
  ROA_BULK_DELETE_FAILED: 'Failed to delete bulk room allocations',
  ROA_BULK_UPDATE_FAILED: 'Failed to update bulk room allocations',
  ROA_OCCUPANCY_STATS_FAILED: 'Failed to fetch room occupancy statistics',
  ROA_STATUS_UPDATE_FAILED: 'Failed to update room allocation status',
  ROA_ID_REQUIRED: 'Room allocation ID is required',
  ROA_BED_INVALID: 'Invalid bed position for room allocation',
  ROA_BED_OCCUPIED: 'Bed position is already occupied',
  ROA_ROOM_INVENTORY_NF: 'Room inventory mapping not found with ID {0}',
  ROA_ROOM_CAPACITY_NA: 'Room capacity information not available for room inventory ID {0}',
  ROA_ROOM_STATUS_INVALID: 'Invalid room status {0} for room allocation',
  ROA_DUPLICATE_REG_IDS: 'Duplicate registration IDs found in the request',
  ROA_DUPLICATE_BED_POSITIONS: 'Duplicate bed positions found in the request',
  ROA_INSUFFICIENT_CAPACITY:
    'Insufficient room capacity in room inventory ID {0}. Requested: {1}, Available: {2}',
  ROA_DUPLICATE_ALLOCATION_IDS: 'Duplicate allocation IDs found in the array',
  ROA_ROOM_MISMATCH: 'Allocation IDs do not belong to the specified room inventory',
  ROA_TRANSFER_FAILED: 'Failed to transfer room allocation with ID {0}',
  ROA_ALREADY_EXISTS: 'Room allocation already exists for registration ID {0}',
  ROA_FILTER_CONFIG_FAILED: 'Failed to generate room allocation filter configuration',
  ROA_INVALID_ALLOCATION_DATA: 'Invalid allocation data provided in the request',

  // Additional missing messages from error-string-constants.ts
  DUPLICATE_PROGRAM_NAMES_IN_GROUP: 'Duplicate program names found in grouped programs',
  SEAT_COUNT_UPDATE_FAILED: 'Failed to update seat count',
  SEAT_COUNT_GET_FAILED: 'Failed to fetch seat count information',
  SEAT_COUNT_NOTFOUND: 'Seat count information not found',
  SEAT_COUNT_FIND_BY_ID_FAILED: 'Failed to find seat count by ID {0}',
  LOOKUP_DATA_GET_FAILED: 'Failed to fetch lookup data',
  CANCELLATION_REASON_GET_FAILED: 'Failed to fetch cancellation reasons',
  FF_GET_FAILED: 'Failed to fetch feature flags',
  FF_CHECK_FAILED: 'Failed to check feature flag status for {0}',
  INVALID_PRIMARY_PROGRAM: 'Invalid primary program configuration',
  PROGRAM_QUESTION_FETCH_FAILED: 'Failed to fetch program questions',
  FORM_SECTION_SAVE_FAILED: 'Failed to save form section',
  FORM_SECTION_UPDATE_FAILED: 'Failed to update form section with ID {0}',
  FORM_SECTION_DELETE_FAILED: 'Failed to delete form section with ID {0}',
  FORM_SECTION_GET_FAILED: 'Failed to fetch form sections',
  FORM_SECTION_COUNT_FAILED: 'Failed to count form sections with criteria {0}',
  RE_CANCEL_FAILED: 'Failed to cancel registration with ID {0}',
  INVOICE_GENERATION_FAILED: 'Failed to generate invoice',
  PT_FIND_BY_ID_FAILED: 'Failed to find program type by ID {0}',

  // Room Inventory Messages
  RI_NF_001: 'Room inventory not found with ID {0}',
  RI_GET_FAILED: 'Failed to fetch room inventory data from the database',
  RI_FIND_BY_ID_FAILED: 'Failed to find room inventory by ID {0}',
  RI_SAVE_FAILED: 'Failed to save room inventory data',
  RI_UPDATE_FAILED: 'Failed to update room inventory with ID {0}',
  RI_DELETE_FAILED: 'Failed to delete room inventory with ID {0}',
  RI_VALIDATION_FAILED: 'Room inventory validation failed',
  RI_KPI_CALCULATION_FAILED: 'Failed to calculate room inventory KPIs',
  RI_FILTER_CONFIG_FAILED: 'Failed to generate room inventory filter configuration',
  RI_PAGINATION_FAILED: 'Failed to paginate room inventory data',
  RI_VENUE_FETCH_FAILED: 'Failed to fetch distinct venues for room inventory',
  RI_BLOCK_FETCH_FAILED: 'Failed to fetch distinct blocks for room inventory',
  RI_FLOOR_FETCH_FAILED: 'Failed to fetch distinct floors for room inventory',
  RI_ROOM_TYPE_FETCH_FAILED: 'Failed to fetch distinct room types for room inventory',
  RI_BED_TYPE_FETCH_FAILED: 'Failed to fetch distinct bed types for room inventory',
  RI_OCCUPANCY_RANGE_FAILED: 'Failed to fetch occupancy range for room inventory',
  RI_RESERVED_WITH_ALLOCATIONS: 'Cannot reserve room inventory with existing allocations',
  RI_RESERVED_ROOM: 'Cannot allocate reserved room',

  // Program Room Inventory Map Messages
  PRIM_NF_001: 'Program room inventory mapping not found with ID {0}',
  PRIM_VALIDATION_FAILED: 'Program room inventory mapping validation failed for ID {0}',
  PRIM_CAPACITY_CHECK_FAILED: 'Failed to check room capacity for inventory ID {0}',
  PRIM_OCCUPANCY_UPDATE_FAILED: 'Failed to update room occupancy for inventory ID {0}',
  PRIM_DEALLOCATION_FAILED: 'Failed to update room occupancy after deallocation for inventory ID {0}',
  PRIM_OCCUPANCY_DETAILS_FAILED: 'Failed to fetch room occupancy details for inventory ID {0}',
  PRIM_STATUS_RECALCULATION_FAILED: 'Failed to recalculate room status for inventory ID {0}',
  PRIM_SAVE_FAILED: 'Failed to save program room inventory mapping',
  PRIM_PROGRAM_MISMATCH: 'Program room inventory mapping does not belong to program ID {0}',
  PRIM_SUBPROGRAM_MISMATCH: 'Program room inventory mapping does not belong to sub-program ID {0}',
  PRIM_INSUFFICIENT_CAPACITY: 'Insufficient room capacity. Required: {0}, Available: {1}',

  REGISTRATION_GROUPING_SAVE_FAILED: 'Failed to save registration grouping',
  REGISTRATION_GROUPING_CREATE_FAILED: 'Failed to create registration grouping',
  REGISTRATION_GROUPING_GET_FAILED: 'Failed to get registration grouping',
  REGISTRATION_GROUPING_UPDATE_FAILED: 'Failed to update registration grouping',
  REGISTRATION_GROUPING_DELETE_FAILED: 'Failed to delete registration grouping',
  REGISTRATION_GROUPING_NOTFOUND: 'Registration grouping not found',
  PAIRING_DUPLICATE: 'Pairing already exists',
  GROUPING_DUPLICATE: 'Grouping already exists',
  REGISTRATION_PAIRING_FAILED: 'Failed to create registration pairing',
  PAIRING_LOOKUP_DATA_NOTFOUND: 'Failed to find pairing lookup data',
  REGISTRATION_PAIRING_OR_GROUPING_VALIDATION_FAILED: 'Registration pairing or grouping validation failed',
  REGISTRATION_GROUPING_VALIDATION_FAILED: 'Registration grouping validation failed',
  REGISTRATION_PAIRING_SAVE_FAILED: 'Failed to save registration pairing',
  REGISTRATION_PAIRING_GET_FAILED: 'Failed to get registration pairing',
  REGISTRATION_PAIRING_DELETE_FAILED: 'Failed to delete registration pairing',
  REGISTRATION_PAIRING_NOTFOUND: 'Registration pairing not found',
  REGISTRATION_GROUPING_ADD_FAILED: 'Failed to add registration grouping',
  REGISTRATION_GROUPING_REMOVE_FAILED: 'Failed to remove registration grouping',
  REGISTRATION_PAIRING_EXCEEDS_MAX_OCCUPANCY:
    'Adding this pairing exceeds the maximum occupancy for the program session',
  SWAP_REQUEST_CHECK_FAILED: 'Failed to check existing swap requests for registration',
  REGISTRATION_WANTS_SWAP_NOT_FOUND: 'No swap request found for registration',
  PREF_PROGRAM_INVALID_START_DATE: 'The following HDB/MSD(s) have already started : {0}. Please review your updated preferences',
  SEEKER_EXPERIENCE_SAVE_FAILED: 'Failed to save seeker experience record',
  SEEKER_EXPERIENCE_UPDATE_FAILED: 'Failed to update seeker experience record',
  SEEKER_EXPERIENCE_FETCH_FAILED: 'Failed to fetch seeker experience record(s)',
  SEEKER_EXPERIENCE_DELETE_FAILED: 'Failed to delete seeker experience record',
  SEEKER_EXPERIENCE_NOT_FOUND: 'Seeker experience record not found for ID {0}',
  SEEKER_PROGRAM_EXPERIENCE_ALREADY_EXISTS: 'Seeker program experience already exists for registration ID {0}',
  SEEKER_EXPERIENCE_REGISTRATION_MISSING: 'Seeker experience registration ID is missing',
};
