import { Entity, PrimaryGeneratedColumn, ManyToOne, JoinColumn, CreateDateColumn, UpdateDateColumn, Column } from 'typeorm';
import { User } from './user.entity';
import { UserRole } from './user-role.entity';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';

@Entity('user_role_map')
@Auditable()
export class UserRoleMap {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => User, (user) => user.userRoleMaps, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @ManyToOne(() => UserRole, (role) => role.userRoleMaps, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'role_id' })
  role: UserRole;

  @SkipAudit()
  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @SkipAudit()
  @UpdateDateColumn({ name: 'updated_at' })
  updatedAt: Date;
}
