import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  JoinColumn,
  OneToOne,
} from 'typeorm';
import { User } from './user.entity';

@Entity('user_profile_extension')
export class UserProfileExtension {
  @PrimaryGeneratedColumn({ type: 'bigint', name: 'id' })
  id: number;

  @OneToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @Column({ name: 'id_front_back_only_from_download_link', type: 'text', nullable: true })
  idFrontBackOnlyFromDownloadLink: string;

  @Column({ name: 'id_back_only_download_link', type: 'text', nullable: true })
  idBackOnlyDownloadLink: string;

  @Column({ name: 'email_to_which_invoice_to_be_sent', type: 'citext', nullable: true })
  emailToWhichInvoiceToBeSent: string;

  @Column({ name: 'name_in_which_invoice_to_be_issued', type: 'text', nullable: true })
  nameInWhichInvoiceToBeIssued: string;

  @Column({ name: 'invoice_address', type: 'text', nullable: true })
  invoiceAddress: string;

  @Column({ name: 'tan', type: 'varchar', length: 20, nullable: true })
  tan: string;

  @Column({ name: 'gstin', type: 'varchar', length: 20, nullable: true })
  gstin: string;

  @Column({ name: 'are_you_registered_under_gst', type: 'boolean', nullable: true })
  areYouRegisteredUnderGst: boolean;

  @Column({ name: 'when_was_your_last_hdb_msd', type: 'text', nullable: true })
  whenWasYourLastHdbMsd: string;

  @Column({ name: 'since_when_have_you_been_associated_with_this_path', type: 'text', nullable: true })
  sinceWhenHaveYouBeenAssociatedWithThisPath: string;

  @Column({ name: 'how_many_hdb_msd_have_you_done', type: 'int', nullable: true })
  howManyHdbMsdHaveYouDone: number;

  @Column({ name: 'which_of_the_following_have_you_experienced', type: 'text', nullable: true })
  whichOfTheFollowingHaveYouExperienced: string;

  @Column({ name: 'song_preference_1', type: 'text', nullable: true })
  songPreference1: string;

  @Column({ name: 'song_preference_2', type: 'text', nullable: true })
  songPreference2: string;

  @Column({ name: 'rm_rating', type: 'decimal', precision: 5, scale: 2, nullable: true })
  rmRating: string;

  @Column({ name: 'rm_review', type: 'text', nullable: true })
  rmReview: string;

  @Column({ name: 'contact_person', type: 'text', nullable: true })
  contactPerson: string;

  @Column({ name: 'hdb_year', type: 'text', nullable: true })
  hdbYear: string;

  @Column({ name: 'infinitheism_contact', type: 'bigint', nullable: true })
  infinitheismContactId: number;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'infinitheism_contact' })
  infinitheismContact: User;

  @Column({ name: 'pincode', type: 'varchar', length: 10, nullable: true })
  pincode: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: true })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedBy: number;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  creator: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updater: User;

  constructor(partial: Partial<UserProfileExtension>) {
    Object.assign(this, partial);
  }
}
