import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { SubProgramTypeEnum } from '../enum/sub-program-type.enum';
import { OriginTypeEnum } from '../enum/origin-type.enum';

@Entity('user_participation_summary')
export class UserParticipationSummary {
  @PrimaryGeneratedColumn({ type: 'bigint', name: 'id' })
  id: number;

  @Column({ name: 'user_id', type: 'bigint', nullable: false })
  userId: number;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @Column({ name: 'program_id', type: 'bigint', nullable: false })
  programId: number;

  @Column({ name: 'program_name', type: 'text', nullable: true })
  programName: string;

  @Column({ name: 'sub_program_id', type: 'bigint', nullable: true })
  subProgramId: number;

  @Column({ name: 'sub_program_name', type: 'text', nullable: true })
  subProgramName: string;

  @Column({ name: 'session_id', type: 'bigint', nullable: true })
  sessionId: number;

  @Column({ name: 'session_name', type: 'text', nullable: true })
  sessionName: string;

  @Column({ name: 'sub_program_type', type: 'enum', enum: SubProgramTypeEnum, nullable: true })
  subProgramType?: SubProgramTypeEnum;

  @Column({ name: 'program_starts_at', type: 'timestamptz', nullable: true })
  programStartsAt: Date;

  @Column({ name: 'program_ends_at', type: 'timestamptz', nullable: true })
  programEndsAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: true })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedBy: number;

  @Column({
    name: 'origin_type',
    type: 'enum',
    enum: OriginTypeEnum,
    enumName: 'origin_type_enum',
    default: OriginTypeEnum.CODE_INSERTED,
  })
  originType: OriginTypeEnum;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt: Date;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  creator: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updater: User;

  constructor(partial: Partial<UserParticipationSummary>) {
    Object.assign(this, partial);
  }
}
