import {
  Column,
  CreateDateColumn,
  DeleteDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { ProgramRegistration } from './program-registration.entity';
import { User } from './user.entity';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';

@Auditable()
@Entity('seeker_program_experience')
export class SeekerProgramExperience {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'user_id', nullable: true })
  userId: number | null;

  @Column({ name: 'registration_id', nullable: true })
  registrationId: number | null;

  @SkipAudit()
  @ManyToOne(() => User , { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'user_id' })
  user: User | null;

  @SkipAudit()
  @ManyToOne(() => ProgramRegistration, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration | null;

  @Column({ name: 'record_type', length: 100 })
  type: string;

  @Column({ name: 'message', type: 'text', nullable: true })
  message?: string;

  @Column({ name: 'media_url', type: 'text' })
  mediaUrl: string;

  @Column({ name: 'is_viewed', default: false })
  isViewed: boolean;

  @Column({ name: 'is_approved', default: false })
  isApproved: boolean;

  @Column({ name: 'is_private', default: false })
  isPrivate: boolean;

  @Column({ name: 'deleted_reason', type: 'text', nullable: true })
  deletedReason?: string | null;

  @Column({ name: 'created_by', nullable: true })
  createdById?: number | null;

  @Column({ name: 'updated_by', nullable: true })
  updatedById?: number | null;

  @Column({ name: 'deleted_by', nullable: true })
  deletedById?: number | null;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'deleted_by' })
  deletedBy?: User | null;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy?: User | null;
  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy?: User | null;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({
    name: 'updated_at',
    type: 'timestamptz',
    default: () => 'CURRENT_TIMESTAMP',
    onUpdate: 'CURRENT_TIMESTAMP',
  })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt?: Date | null;

  constructor(partial?: Partial<SeekerProgramExperience>) {
    if (partial) {
      Object.assign(this, partial);
    }
  }
}