import {
  Column,
  CreateDateColumn,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { User } from './user.entity';

/**
 * Entity for tracking scheduler job execution attempts, status, and history
 */
@Entity('portal_scheduler_logs')
export class SchedulerLog {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'job_name', type: 'varchar', length: 100, nullable: false })
  jobName: string;

  @Column({ name: 'job_type', type: 'varchar', length: 100, nullable: false })
  jobType: string;

  @Column({ name: 'request_payload', type: 'jsonb', nullable: true })
  requestPayload: any;

  @Column({ name: 'response_data', type: 'jsonb', nullable: true })
  responseData: any;

  @Column({ name: 'execution_status', type: 'varchar', length: 50, nullable: false, default: 'pending' })
  executionStatus: 'pending' | 'success' | 'failed' | 'in_progress';

  @Column({ name: 'attempt_number', type: 'integer', nullable: false, default: 1 })
  attemptNumber: number;

  @Column({ name: 'total_attempts', type: 'integer', nullable: false, default: 1 })
  totalAttempts: number;

  @Column({ name: 'error_message', type: 'text', nullable: true })
  errorMessage: string;

  @Column({ name: 'error_stack', type: 'text', nullable: true })
  errorStack: string;

  @Column({ name: 'execution_time_ms', type: 'integer', nullable: true })
  executionTimeMs: number;

  @Column({ name: 'program_id', type: 'bigint', nullable: true })
  programId: number;

  @Column({ name: 'registration_id', type: 'bigint', nullable: true })
  registrationId: number;

  @Column({ name: 'triggered_by_user_id', type: 'bigint', nullable: false })
  triggeredByUserId: number;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'triggered_by_user_id' })
  triggeredByUser: User;

  @Column({ name: 'triggered_type', type: 'varchar', length: 50, nullable: false, default: 'scheduled' })
  triggeredType: 'manual' | 'scheduled' | 'automatic';

  @Column({ name: 'completed_at', type: 'timestamp with time zone', nullable: true })
  completedAt: Date;

  @Column({ name: 'failed_at', type: 'timestamp with time zone', nullable: true })
  failedAt: Date;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp with time zone', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp with time zone', default: () => 'CURRENT_TIMESTAMP' })
  updatedAt: Date;
}
